/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IByteArrayDecoder;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IByteArrayStreamDecoder
extends IByteArrayDecoder {
    default public void decode(byte @Nullable [] byArray, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null) {
            this.decode(null, 0, 0, outputStream);
        } else {
            this.decode(byArray, 0, byArray.length, outputStream);
        }
    }

    public void decode(byte @Nullable [] var1, @Nonnegative int var2, @Nonnegative int var3, @WillNotClose @NonNull OutputStream var4);

    @Override
    @ReturnsMutableCopy
    default public byte @Nullable [] getDecoded(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getMaximumDecodedLength(n2));){
            this.decode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            byte[] byArray2 = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray2;
        }
    }

    default public @Nullable String getDecodedAsString(byte @Nullable [] byArray, @NonNull Charset charset) {
        if (byArray == null) {
            return null;
        }
        return this.getDecodedAsString(byArray, 0, byArray.length, charset);
    }

    default public @Nullable String getDecodedAsString(byte @Nullable [] byArray, @Nonnegative int n, @Nonnegative int n2, @NonNull Charset charset) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getMaximumDecodedLength(n2));){
            this.decode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    default public @Nullable String getDecodedAsString(@Nullable String string, @NonNull Charset charset) {
        return this.getDecodedAsString(string, charset, charset);
    }

    default public @Nullable String getDecodedAsString(@Nullable String string, @NonNull Charset charset, @NonNull Charset charset2) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getDecodedAsString(byArray, 0, byArray.length, charset2);
    }
}

