/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.CheckForSigned;
import com.helger.base.string.StringParser;
import com.helger.base.system.SystemProperties;
import org.jspecify.annotations.NonNull;

public enum EProcessorArchitecture {
    UNKNOWN(-1),
    ARCH_32(32),
    ARCH_64(64);

    private static final String SYSTEM_PROPERTY_SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    private static final EProcessorArchitecture INSTANCE;
    private final int m_nBits;

    private EProcessorArchitecture(int n2) {
        if (n2 > 0 && n2 % 8 != 0) {
            throw new IllegalArgumentException("Passed bit count is illegal: " + n2);
        }
        this.m_nBits = n2;
    }

    public int getBits() {
        return this.m_nBits;
    }

    public int getBytes() {
        return this.m_nBits == -1 ? this.m_nBits : this.m_nBits / 8;
    }

    @CheckForSigned
    public static int getCurrentArchitectureBits() {
        String string = SystemProperties.getPropertyValue(SYSTEM_PROPERTY_SUN_ARCH_DATA_MODEL);
        return StringParser.parseInt(string, -1);
    }

    public static @NonNull EProcessorArchitecture forBits(int n) {
        for (EProcessorArchitecture eProcessorArchitecture : EProcessorArchitecture.values()) {
            if (n != eProcessorArchitecture.getBits()) continue;
            return eProcessorArchitecture;
        }
        return UNKNOWN;
    }

    public static @NonNull EProcessorArchitecture getCurrentArchitecture() {
        return INSTANCE;
    }

    static {
        INSTANCE = EProcessorArchitecture.forBits(EProcessorArchitecture.getCurrentArchitectureBits());
    }
}

