/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.Nonempty;
import com.helger.base.name.IHasDisplayName;
import com.helger.base.system.ENewLineMode;
import com.helger.base.system.SystemProperties;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EOperatingSystem implements IHasDisplayName
{
    AIX("AIX", true),
    FREEBSD("FreeBSD", true),
    HPUX("HP-UX", true),
    LINUX("Linux", true),
    MACOS("Mac OS X", true),
    SOLARIS("Solaris", true),
    WINDOWS("Windows", false),
    ZOS("z/OS", true),
    UNKNOWN("Unknown", false);

    private static final Logger LOGGER;
    private static final EOperatingSystem INSTANCE;
    private final String m_sDisplayName;
    private final boolean m_bUnixBased;

    private EOperatingSystem(String string2, boolean bl) {
        this.m_sDisplayName = string2;
        this.m_bUnixBased = bl;
    }

    @Override
    @Nonempty
    public @NonNull String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean isUnixBased() {
        return this.m_bUnixBased;
    }

    public boolean isWindowsBased() {
        return this == WINDOWS;
    }

    public boolean isMacOSBased() {
        return this == MACOS;
    }

    public boolean isCurrentOS() {
        return this == EOperatingSystem.getCurrentOS();
    }

    public @NonNull ENewLineMode getNewLineMode() {
        if (this.isWindowsBased()) {
            return ENewLineMode.WINDOWS;
        }
        if (this.isMacOSBased()) {
            return ENewLineMode.MAC;
        }
        return ENewLineMode.UNIX;
    }

    public static @NonNull EOperatingSystem forName(@Nullable String string) {
        if (string == null) {
            return UNKNOWN;
        }
        String string2 = string.toLowerCase(Locale.US);
        if (string2.contains("solaris") || string2.contains("sunos")) {
            return SOLARIS;
        }
        if (string2.contains("linux")) {
            return LINUX;
        }
        if (string2.contains("hp-ux") || string2.contains("hp ux") || string2.contains("hpux")) {
            return HPUX;
        }
        if (string2.contains("aix")) {
            return AIX;
        }
        if (string2.contains("windows")) {
            return WINDOWS;
        }
        if (string2.contains("freebsd") || string2.contains("free bsd")) {
            return FREEBSD;
        }
        if (string2.contains("macos") || string2.contains("mac os")) {
            return MACOS;
        }
        if (string2.contains("z/os")) {
            return ZOS;
        }
        return UNKNOWN;
    }

    public static @NonNull EOperatingSystem getCurrentOS() {
        return INSTANCE;
    }

    public static @Nullable String getCurrentOSName() {
        return SystemProperties.getOsName();
    }

    public static @Nullable String getCurrentOSVersion() {
        return SystemProperties.getOsVersion();
    }

    static {
        LOGGER = LoggerFactory.getLogger(EOperatingSystem.class);
        String string = EOperatingSystem.getCurrentOSName();
        INSTANCE = EOperatingSystem.forName(string);
        if (INSTANCE == UNKNOWN) {
            LOGGER.error("Failed to resolve operating system from name '" + string + "'!!!");
        }
    }
}

