/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.location;

import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.string.StringHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@MustImplementEqualsAndHashcode
public interface ILocation {
    public static final int ILLEGAL_NUMBER = -1;

    public @Nullable String getResourceID();

    default public boolean hasResourceID() {
        return StringHelper.isNotEmpty(this.getResourceID());
    }

    public int getLineNumber();

    default public boolean hasLineNumber() {
        return this.getLineNumber() > -1;
    }

    public int getColumnNumber();

    default public boolean hasColumnNumber() {
        return this.getColumnNumber() > -1;
    }

    default public boolean isAnyInformationPresent() {
        return this.hasResourceID() || this.hasLineNumber() || this.hasColumnNumber();
    }

    default public @NonNull String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getResourceID();
        if (StringHelper.isNotEmpty(string)) {
            stringBuilder.append(string);
        }
        if (this.hasLineNumber()) {
            if (this.hasColumnNumber()) {
                stringBuilder.append("(").append(this.getLineNumber()).append(":").append(this.getColumnNumber()).append(")");
            } else {
                stringBuilder.append("(").append(this.getLineNumber()).append(":?)");
            }
        } else if (this.hasColumnNumber()) {
            stringBuilder.append("(?:").append(this.getColumnNumber()).append(")");
        }
        return stringBuilder.toString();
    }
}

