/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.lang;

import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.system.ENewLineMode;
import com.helger.base.system.SystemProperties;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;

@Immutable
public final class ClassPathHelper {
    private static final ClassPathHelper INSTANCE = new ClassPathHelper();

    private ClassPathHelper() {
    }

    @ReturnsMutableCopy
    public static @NonNull List<String> getAllClassPathEntries() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPathHelper.forAllClassPathEntries(arrayList::add);
        return arrayList;
    }

    public static void forAllClassPathEntries(@NonNull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        StringHelper.explode(SystemProperties.getPathSeparator(), SystemProperties.getJavaClassPath(), consumer);
    }

    public static void printClassPathEntries(@NonNull PrintStream printStream) {
        ClassPathHelper.printClassPathEntries(printStream, ENewLineMode.DEFAULT.getText());
    }

    public static void printClassPathEntries(@NonNull PrintStream printStream, @NonNull String string) {
        ClassPathHelper.forAllClassPathEntries(string2 -> {
            printStream.print((String)string2);
            printStream.print(string);
        });
    }
}

