/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.IByteArrayEncoder;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface IByteArrayStreamEncoder
extends IByteArrayEncoder {
    @Override
    @Nonnegative
    default public int getMaximumEncodedLength(@Nonnegative int n) {
        return n;
    }

    default public void encode(@Nullable byte[] byArray, @WillNotClose @NonNull OutputStream outputStream) {
        if (byArray == null) {
            this.encode(null, 0, 0, outputStream);
        } else {
            this.encode(byArray, 0, byArray.length, outputStream);
        }
    }

    public void encode(@Nullable byte[] var1, @Nonnegative int var2, @Nonnegative int var3, @WillNotClose @NonNull OutputStream var4);

    @Override
    @ReturnsMutableCopy
    default public @Nullable byte[] getEncoded(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return this.getEncoded(byArray, 0, byArray.length);
    }

    @Override
    @ReturnsMutableCopy
    default public @Nullable byte[] getEncoded(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getMaximumEncodedLength(n2));){
            this.encode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            byte[] byArray2 = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray2;
        }
    }

    @Override
    @ReturnsMutableCopy
    default public @Nullable byte[] getEncoded(@Nullable String string, @NonNull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncoded(byArray, 0, byArray.length);
    }

    default public @Nullable String getEncodedAsString(@Nullable byte[] byArray, @NonNull Charset charset) {
        if (byArray == null) {
            return null;
        }
        return this.getEncodedAsString(byArray, 0, byArray.length, charset);
    }

    default public @Nullable String getEncodedAsString(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @NonNull Charset charset) {
        if (byArray == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(this.getMaximumEncodedLength(n2));){
            this.encode(byArray, n, n2, nonBlockingByteArrayOutputStream);
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    default public @Nullable String getEncodedAsString(@Nullable String string, @NonNull Charset charset) {
        if (string == null) {
            return null;
        }
        byte[] byArray = string.getBytes(charset);
        return this.getEncodedAsString(byArray, 0, byArray.length, charset);
    }
}

