/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.string;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.functional.ICharConsumer;
import com.helger.base.functional.ICharPredicate;
import com.helger.base.numeric.MathHelper;
import com.helger.base.string.StringCount;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;

@Immutable
public class StringHelper {
    private static final StringHelper INSTANCE = new StringHelper();

    protected StringHelper() {
    }

    public static boolean isEmpty(@Nullable CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isEmptyAfterTrim(@Nullable String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isNotEmpty(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean isNotEmpty(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean isNotEmptyAfterTrim(@Nullable String string) {
        return string != null && !string.trim().isEmpty();
    }

    @Deprecated(forRemoval=true, since="12.0.0")
    public static boolean hasNoText(@Nullable CharSequence charSequence) {
        return StringHelper.isEmpty(charSequence);
    }

    @Deprecated(forRemoval=true, since="12.0.0")
    public static boolean hasNoText(@Nullable String string) {
        return StringHelper.isEmpty(string);
    }

    @Deprecated(forRemoval=true, since="12.0.0")
    public static boolean hasText(@Nullable CharSequence charSequence) {
        return StringHelper.isNotEmpty(charSequence);
    }

    @Deprecated(forRemoval=true, since="12.0.0")
    public static boolean hasText(@Nullable String string) {
        return StringHelper.isNotEmpty(string);
    }

    @Deprecated(forRemoval=true, since="12.0.0")
    public static boolean hasTextAfterTrim(@Nullable String string) {
        return StringHelper.isNotEmptyAfterTrim(string);
    }

    @Nonnegative
    public static int getLength(@Nullable CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    @Nonnull
    public static String getNotNull(@Nullable String string) {
        return StringHelper.getNotNull(string, "");
    }

    @Nullable
    public static String getNotNull(@Nullable String string, @Nullable String string2) {
        return string == null ? string2 : string;
    }

    @Nullable
    public static String getNotNull(@Nullable String string, @Nonnull Supplier<String> supplier) {
        return string == null ? supplier.get() : string;
    }

    @Nonnull
    public static CharSequence getNotNull(@Nullable CharSequence charSequence) {
        return StringHelper.getNotNull(charSequence, (CharSequence)"");
    }

    @Nullable
    public static CharSequence getNotNull(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        return charSequence == null ? charSequence2 : charSequence;
    }

    @Nullable
    public static CharSequence getNotNull(@Nullable CharSequence charSequence, @Nonnull Supplier<? extends CharSequence> supplier) {
        return charSequence == null ? supplier.get() : charSequence;
    }

    @Nullable
    public static String getNotEmpty(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasNoText(string) ? string2 : string;
    }

    @Nullable
    public static String getNotEmpty(@Nullable String string, @Nonnull Supplier<String> supplier) {
        return StringHelper.hasNoText(string) ? supplier.get() : string;
    }

    @Nullable
    public static CharSequence getNotEmpty(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        return StringHelper.isEmpty(charSequence) ? charSequence2 : charSequence;
    }

    @Nullable
    public static CharSequence getNotEmpty(@Nullable CharSequence charSequence, @Nullable Supplier<? extends CharSequence> supplier) {
        return StringHelper.isEmpty(charSequence) ? supplier.get() : charSequence;
    }

    @Nonnull
    public static String getRepeated(char c, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Repeats");
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return Character.toString(c);
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    @Nonnull
    public static String getRepeated(@Nonnull String string, @Nonnegative int n) {
        ValueEnforcer.notNull(string, "Element");
        ValueEnforcer.isGE0(n, "Repeats");
        int n2 = string.length();
        if ((long)n2 * (long)n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Resulting string exceeds the maximum integer length");
        }
        if (n2 == 0 || n == 0) {
            return "";
        }
        if (n == 1) {
            return string;
        }
        if (n2 == 1) {
            return StringHelper.getRepeated(string.charAt(0), n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    private static String _getWithLeadingOrTrailing(@Nullable String string, @Nonnegative int n, char c, boolean bl) {
        if (n <= 0) {
            return StringHelper.getNotNull(string, "");
        }
        int n2 = StringHelper.getLength(string);
        if (n2 == 0) {
            return StringHelper.getRepeated(c, n);
        }
        int n3 = n - n2;
        if (n3 <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (!bl) {
            stringBuilder.append(string);
        }
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getWithLeading(@Nullable String string, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(string, n, c, true);
    }

    @Nonnull
    public static String getWithLeading(int n, @Nonnegative int n2, char c) {
        return StringHelper._getWithLeadingOrTrailing(Integer.toString(n), n2, c, true);
    }

    @Nonnull
    public static String getWithLeading(long l, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(Long.toString(l), n, c, true);
    }

    @Nonnull
    public static String getWithTrailing(@Nullable String string, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(string, n, c, false);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Byte by, int n) {
        return by == null ? null : StringHelper.getLeadingZero((int)by.byteValue(), n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Integer n, int n2) {
        return n == null ? null : StringHelper.getLeadingZero(n.longValue(), n2);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Long l, int n) {
        return l == null ? null : StringHelper.getLeadingZero((long)l, n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Short s, int n) {
        return s == null ? null : StringHelper.getLeadingZero((int)s.shortValue(), n);
    }

    @Nonnull
    public static String getLeadingZero(int n, int n2) {
        boolean bl = n < 0;
        String string = Integer.toString(MathHelper.abs(n));
        if (string.length() >= n2) {
            return bl ? "-" + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n2);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(long l, int n) {
        boolean bl = l < 0L;
        String string = Long.toString(MathHelper.abs(l));
        if (string.length() >= n) {
            return bl ? "-" + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(@Nonnull String string, int n) {
        return StringHelper.getWithLeading(string, n, '0');
    }

    @Nullable
    public static String getReverse(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length <= 1) {
            return string;
        }
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        int n2 = 0;
        while (n >= 0) {
            cArray2[n2] = cArray[n];
            --n;
            ++n2;
        }
        return new String(cArray2);
    }

    public static char getFirstChar(@Nullable CharSequence charSequence) {
        return StringHelper.isNotEmpty(charSequence) ? charSequence.charAt(0) : (char)'\u0000';
    }

    public static char getFirstChar(@Nullable char[] cArray) {
        return ArrayHelper.getFirst(cArray, '\u0000');
    }

    public static char getLastChar(@Nullable CharSequence charSequence) {
        int n = StringHelper.getLength(charSequence);
        return n > 0 ? charSequence.charAt(n - 1) : (char)'\u0000';
    }

    public static char getLastChar(@Nullable char[] cArray) {
        return ArrayHelper.getLast(cArray, '\u0000');
    }

    public static int getIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.indexOf(string2) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.indexOf(string2, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.lastIndexOf(string2) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.lastIndexOf(string2, n) : -1;
    }

    public static int getIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.indexOf(c) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.indexOf(c, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.lastIndexOf(c) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.lastIndexOf(c, n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c), n) : -1;
    }

    public static boolean contains(@Nullable String string, @Nullable String string2) {
        return StringHelper.getIndexOf(string, string2) != -1;
    }

    public static boolean contains(@Nullable String string, char c) {
        return StringHelper.getIndexOf(string, c) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, string2, locale) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, c, locale) != -1;
    }

    public static boolean containsAny(@Nullable char[] cArray, @Nonnull char[] cArray2) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        if (cArray != null) {
            for (char c : cArray) {
                if (!ArrayHelper.contains(cArray2, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String string, @Nonnull char[] cArray) {
        return string != null && StringHelper.containsAny(string.toCharArray(), cArray);
    }

    public static void iterateChars(@Nullable String string, @Nonnull ICharConsumer iCharConsumer) {
        ValueEnforcer.notNull(iCharConsumer, "Consumer");
        if (string != null) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                iCharConsumer.accept(c);
            }
        }
    }

    public static boolean containsAny(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (iCharPredicate == null) {
            return n > 0;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!iCharPredicate.test(charSequence.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (iCharPredicate == null) {
            return n > 0;
        }
        if (n > 0) {
            for (char c : string.toCharArray()) {
                if (!iCharPredicate.test(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNone(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (iCharPredicate == null) {
            return n == 0;
        }
        for (int i = 0; i < n; ++i) {
            if (!iCharPredicate.test(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNone(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (iCharPredicate == null) {
            return n == 0;
        }
        if (n > 0) {
            for (char c : string.toCharArray()) {
                if (!iCharPredicate.test(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsOnly(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (n == 0) {
            return false;
        }
        if (iCharPredicate == null) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (iCharPredicate.test(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnly(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (n == 0) {
            return false;
        }
        if (iCharPredicate == null) {
            return true;
        }
        for (char c : string.toCharArray()) {
            if (iCharPredicate.test(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllWhitespace(@Nullable CharSequence charSequence) {
        return StringHelper.containsOnly(charSequence, Character::isWhitespace);
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.isNotEmpty(charSequence) && charSequence.charAt(0) == c;
    }

    public static boolean startsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        return StringHelper.isNotEmpty(charSequence) && cArray != null && ArrayHelper.contains(cArray, charSequence.charAt(0));
    }

    public static boolean startsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.isNotEmpty(charSequence) && Character.toLowerCase(charSequence.charAt(0)) == Character.toLowerCase(c);
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n = charSequence2.length();
        if (n == 0) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 < n) {
            return false;
        }
        return charSequence.subSequence(0, n).equals(charSequence2);
    }

    public static boolean startsWith(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return string.charAt(0) == string2.charAt(0);
        }
        return string.subSequence(0, n).equals(string2);
    }

    public static boolean startsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        return string.substring(0, n).equalsIgnoreCase(string2);
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.isNotEmpty(charSequence) && StringHelper.getLastChar(charSequence) == c;
    }

    public static boolean endsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        return StringHelper.isNotEmpty(charSequence) && cArray != null && ArrayHelper.contains(cArray, StringHelper.getLastChar(charSequence));
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n = charSequence2.length();
        if (n == 0) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return charSequence.charAt(n2 - 1) == charSequence2.charAt(0);
        }
        return charSequence.subSequence(n2 - n, n2).equals(charSequence2);
    }

    public static boolean endsWith(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return string.charAt(n2 - 1) == string2.charAt(0);
        }
        return string.startsWith(string2, n2 - n);
    }

    public static boolean endsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.isNotEmpty(charSequence) && Character.toLowerCase(StringHelper.getLastChar(charSequence)) == Character.toLowerCase(c);
    }

    public static boolean endsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        return string.substring(n2 - n, n2).equalsIgnoreCase(string2);
    }

    public static void iterateCodePoints(@Nullable String string, @Nonnull IntConsumer intConsumer) {
        ValueEnforcer.notNull(intConsumer, "Consumer");
        if (string != null) {
            int n;
            int n2 = string.length();
            for (int i = 0; i < n2; i += Character.charCount(n)) {
                n = string.codePointAt(i);
                intConsumer.accept(n);
            }
        }
    }

    public static void explode(char c, @Nullable String string, @Nonnull Consumer<? super String> consumer) {
        StringHelper.explode(c, string, -1, consumer);
    }

    public static void explode(char c, @Nullable String string, int n, @Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        if (n == 1) {
            consumer.accept(string);
        } else if (StringHelper.isNotEmpty(string)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string.indexOf(c, n3)) >= 0) {
                consumer.accept(string.substring(n3, n2));
                n3 = n2 + 1;
                if (n <= 0 || ++n4 != n - 1) continue;
            }
            consumer.accept(string.substring(n3));
        }
    }

    public static void explode(@Nonnull String string, @Nullable String string2, @Nonnull Consumer<? super String> consumer) {
        StringHelper.explode(string, string2, -1, consumer);
    }

    public static void explode(@Nonnull String string, @Nullable String string2, int n, @Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(string, "Separator");
        ValueEnforcer.notNull(consumer, "Collection");
        if (string.length() == 1) {
            StringHelper.explode(string.charAt(0), string2, n, consumer);
        } else if (n == 1) {
            consumer.accept(string2);
        } else if (StringHelper.isNotEmpty(string2)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string2.indexOf(string, n3)) >= 0) {
                consumer.accept(string2.substring(n3, n2));
                n3 = n2 + string.length();
                if (n <= 0 || ++n4 != n - 1) continue;
                break;
            }
            consumer.accept(string2.substring(n3));
        }
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string, @CheckForSigned int n) {
        int n2;
        if (n == 1) {
            return new String[]{string};
        }
        if (StringHelper.isEmpty(string)) {
            return CGlobal.EMPTY_STRING_ARRAY;
        }
        int n3 = 1 + StringCount.getCharCount(string, c);
        if (n3 == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n < 1 ? n3 : Math.min(n3, n)];
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(c, n4)) >= 0) {
            stringArray[n5++] = string.substring(n4, n2);
            n4 = n2 + 1;
            if (n <= 0 || n5 != n - 1) continue;
            break;
        }
        stringArray[n5++] = string.substring(n4);
        if (n5 != stringArray.length) {
            throw new IllegalStateException("Added " + n5 + " but expected " + stringArray.length);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string) {
        return StringHelper.getExplodedArray(c, string, -1);
    }

    @Nonnull
    @ReturnsMutableObject(value="The passed parameter")
    @CodingStyleguideUnaware
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(char c, @Nullable String string, int n, @Nonnull COLLTYPE COLLTYPE) {
        StringHelper.explode(c, string, n, COLLTYPE::add);
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char c, @Nullable String string) {
        return StringHelper.getExploded(c, string, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(char c, @Nullable String string, int n) {
        return StringHelper.getExploded(c, string, n, n >= 1 ? new ArrayList(n) : new ArrayList());
    }

    @Nonnull
    @CodingStyleguideUnaware
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(@Nonnull String string, @Nullable String string2, int n, @Nonnull COLLTYPE COLLTYPE) {
        StringHelper.explode(string, string2, n, COLLTYPE::add);
        return COLLTYPE;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<String> getExploded(@Nonnull String string, @Nullable String string2, int n) {
        return StringHelper.getExploded(string, string2, n, n >= 1 ? new ArrayList(n) : new ArrayList());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static HashSet<String> getExplodedToSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new HashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static LinkedHashSet<String> getExplodedToOrderedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new LinkedHashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<String> getExplodedToSortedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new TreeSet());
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2) {
        if (string == null) {
            return string2 == null ? "" : string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.isNotEmpty(string)) {
            stringBuilder.append(string);
            if (StringHelper.isNotEmpty(string2) && StringHelper.isNotEmpty(string3)) {
                stringBuilder.append(string2);
            }
        }
        if (StringHelper.isNotEmpty(string3)) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, char c, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.isNotEmpty(string)) {
            stringBuilder.append(string);
            if (StringHelper.isNotEmpty(string2)) {
                stringBuilder.append(c);
            }
        }
        if (StringHelper.isNotEmpty(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getQuoted(@Nullable String string) {
        return string == null ? "null" : "'" + string + "'";
    }

    public static void appendQuoted(@Nonnull StringBuilder stringBuilder, @Nullable String string) {
        if (string == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append('\'').append(string).append('\'');
        }
    }

    public static void appendQuoted(@Nonnull Appendable appendable, @Nullable String string) throws IOException {
        if (string == null) {
            appendable.append("null");
        } else {
            appendable.append('\'').append(string).append('\'');
        }
    }

    @Nullable
    @CheckReturnValue
    public static String trimLeadingWhitespaces(@Nullable String string) {
        int n = StringCount.getLeadingWhitespaceCount(string);
        return n == 0 ? string : string.substring(n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimTrailingWhitespaces(@Nullable String string) {
        int n = StringCount.getTrailingWhitespaceCount(string);
        return n == 0 ? string : string.substring(0, string.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, @Nullable String string2) {
        return StringHelper.startsWith(string, string2) ? string.substring(string2.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartRepeatedly(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        String string3 = string;
        while (StringHelper.startsWith(string3, string2)) {
            string3 = string3.substring(n);
        }
        return string3;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, char c) {
        return StringHelper.startsWith((CharSequence)string, c) ? string.substring(1) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartRepeatedly(@Nullable String string, char c) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        String string2 = string;
        while (StringHelper.startsWith((CharSequence)string2, c)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, @Nonnegative int n) {
        if (n <= 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.endsWith(string, string2) ? string.substring(0, string.length() - string2.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEndRepeatedly(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        String string3 = string;
        while (StringHelper.endsWith(string3, string2)) {
            string3 = string3.substring(0, string3.length() - n);
        }
        return string3;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, char c) {
        return StringHelper.endsWith((CharSequence)string, c) ? string.substring(0, string.length() - 1) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEndRepeatedly(@Nullable String string, char c) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        String string2 = string;
        while (StringHelper.endsWith((CharSequence)string2, c)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, @Nonnegative int n) {
        if (n <= 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(0, string.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.trimStartAndEnd(string, string2, string2);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.trimStart(string, string2);
        return StringHelper.trimEnd(string4, string3);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, char c) {
        return StringHelper.trimStartAndEnd(string, c, c);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, char c, char c2) {
        String string2 = StringHelper.trimStart(string, c);
        return StringHelper.trimEnd(string2, c2);
    }

    @Nullable
    @CheckReturnValue
    public static String trim(@Nullable String string) {
        return StringHelper.isEmpty(string) ? string : string.trim();
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n) {
        return StringHelper.getCutAfterLength(string, n, null);
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n, @Nullable String string2) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.isGE0(n, "MaxLength");
        if (string.length() <= n) {
            return string;
        }
        if (StringHelper.isEmpty(string2)) {
            return string.substring(0, n);
        }
        return string.substring(0, n) + string2;
    }

    @Nonnull
    public static String getToString(@Nullable Object object) {
        return StringHelper.getToString(object, "");
    }

    @Nullable
    public static String getToString(@Nullable Object object, @Nullable String string) {
        return object == null ? string : object.toString();
    }

    @Nonnull
    public static String getWithoutLeadingChar(@Nullable String string) {
        return StringHelper.getWithoutLeadingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutLeadingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(n);
    }

    @Nonnull
    public static String getWithoutTrailingChar(@Nullable String string) {
        return StringHelper.getWithoutTrailingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutTrailingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        int n2 = StringHelper.getLength(string);
        return n2 <= n ? "" : string.substring(0, n2 - n);
    }

    @Nonnull
    public static String getWithoutAnySpaces(@Nullable String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.trim().toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        for (char c : cArray) {
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, false);
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.isEmpty(string2)) {
            return "";
        }
        int n = StringHelper.getIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.isEmpty(string2)) {
            return "";
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.isEmpty(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.isEmpty(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, false);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, char c) {
        int n = StringHelper.getIndexOf(string, c);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, char c) {
        int n = StringHelper.getLastIndexOf(string, c);
        return n == -1 ? string : string.substring(n + 1);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.isEmpty(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        return n == -1 ? string : string.substring(n + StringHelper.getLength(string2));
    }
}

