/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.builder.IBuilder;
import com.helger.base.callback.exception.IExceptionCallback;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedInputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedOutputStream;
import com.helger.base.io.nonblocking.NonBlockingBufferedReader;
import com.helger.base.io.nonblocking.NonBlockingBufferedWriter;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayOutputStream;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.nonblocking.NonBlockingStringWriter;
import com.helger.base.io.stream.ByteBufferInputStream;
import com.helger.base.io.stream.ByteBufferOutputStream;
import com.helger.base.io.stream.WrappedInputStream;
import com.helger.base.io.stream.WrappedOutputStream;
import com.helger.base.io.stream.WrappedReader;
import com.helger.base.io.stream.WrappedWriter;
import com.helger.base.mock.exception.IMockException;
import com.helger.base.numeric.mutable.MutableLong;
import com.helger.base.state.ESuccess;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.LongConsumer;
import java.util.function.ObjIntConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class StreamHelper {
    public static final int DEFAULT_BUFSIZE = 16384;
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamHelper.class);
    private static final StreamHelper INSTANCE = new StreamHelper();
    public static final int END_OF_STRING_MARKER = -131075;

    protected StreamHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] createDefaultCopyBufferBytes() {
        return new byte[16384];
    }

    @Nonnull
    @ReturnsMutableCopy
    public static char[] createDefaultCopyBufferChars() {
        return new char[16384];
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull String string) {
        return new NonBlockingStringReader(string);
    }

    @Nonnull
    public static NonBlockingStringReader createReader(@Nonnull char[] cArray) {
        return new NonBlockingStringReader(cArray);
    }

    @Nullable
    public static InputStreamReader createReader(@Nullable InputStream inputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return inputStream == null ? null : new InputStreamReader(inputStream, charset);
    }

    @Nullable
    public static OutputStreamWriter createWriter(@Nullable OutputStream outputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        return outputStream == null ? null : new OutputStreamWriter(outputStream, charset);
    }

    public static boolean isKnownEOFException(@Nullable Throwable throwable) {
        return throwable != null && StreamHelper.isKnownEOFException(throwable.getClass());
    }

    public static boolean isKnownEOFException(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        return string.equals("java.io.EOFException") || string.equals("org.mortbay.jetty.EofException") || string.equals("org.eclipse.jetty.io.EofException") || string.equals("org.apache.catalina.connector.ClientAbortException");
    }

    @Nullable
    protected static Exception internalGetPropagatableException(@Nonnull Exception exception) {
        return exception instanceof IMockException ? null : exception;
    }

    @Nonnull
    public static ESuccess closeWithoutFlush(@Nullable @WillClose AutoCloseable autoCloseable) {
        block3: {
            if (autoCloseable != null) {
                try {
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block3;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess close(@Nullable @WillClose AutoCloseable autoCloseable) {
        block5: {
            if (autoCloseable != null) {
                try {
                    if (autoCloseable instanceof Flushable) {
                        Flushable flushable = (Flushable)((Object)autoCloseable);
                        StreamHelper.flush(flushable);
                    }
                    autoCloseable.close();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Exception exception) {
                    if (StreamHelper.isKnownEOFException(exception)) break block5;
                    LOGGER.error("Failed to close object " + autoCloseable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(exception));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess flush(@Nullable Flushable flushable) {
        block4: {
            if (flushable != null) {
                try {
                    flushable.flush();
                    return ESuccess.SUCCESS;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {
                    if (StreamHelper.isKnownEOFException(iOException)) break block4;
                    LOGGER.error("Failed to flush object " + flushable.getClass().getName(), (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
        }
        return ESuccess.FAILURE;
    }

    public static boolean isBuffered(@Nullable InputStream inputStream) {
        WrappedInputStream wrappedInputStream;
        return inputStream instanceof BufferedInputStream || inputStream instanceof NonBlockingBufferedInputStream || inputStream instanceof ByteArrayInputStream || inputStream instanceof NonBlockingByteArrayInputStream || inputStream instanceof ByteBufferInputStream || inputStream instanceof WrappedInputStream && StreamHelper.isBuffered((wrappedInputStream = (WrappedInputStream)inputStream).getWrappedInputStream());
    }

    @Nullable
    public static InputStream getBuffered(@Nullable InputStream inputStream) {
        return inputStream == null || StreamHelper.isBuffered(inputStream) ? inputStream : new NonBlockingBufferedInputStream(inputStream);
    }

    public static boolean isBuffered(@Nullable OutputStream outputStream) {
        WrappedOutputStream wrappedOutputStream;
        return outputStream instanceof BufferedOutputStream || outputStream instanceof NonBlockingBufferedOutputStream || outputStream instanceof ByteArrayOutputStream || outputStream instanceof NonBlockingByteArrayOutputStream || outputStream instanceof ByteBufferOutputStream || outputStream instanceof WrappedOutputStream && StreamHelper.isBuffered((wrappedOutputStream = (WrappedOutputStream)outputStream).getWrappedOutputStream());
    }

    @Nullable
    public static OutputStream getBuffered(@Nullable OutputStream outputStream) {
        return outputStream == null || StreamHelper.isBuffered(outputStream) ? outputStream : new NonBlockingBufferedOutputStream(outputStream);
    }

    public static boolean isBuffered(@Nullable Reader reader) {
        WrappedReader wrappedReader;
        return reader instanceof BufferedReader || reader instanceof NonBlockingBufferedReader || reader instanceof StringReader || reader instanceof NonBlockingStringReader || reader instanceof WrappedReader && StreamHelper.isBuffered((wrappedReader = (WrappedReader)reader).getWrappedReader());
    }

    @Nullable
    public static Reader getBuffered(@Nullable Reader reader) {
        return reader == null || StreamHelper.isBuffered(reader) ? reader : new NonBlockingBufferedReader(reader);
    }

    public static boolean isBuffered(@Nullable Writer writer) {
        WrappedWriter wrappedWriter;
        return writer instanceof BufferedWriter || writer instanceof NonBlockingBufferedWriter || writer instanceof StringWriter || writer instanceof NonBlockingStringWriter || writer instanceof WrappedWriter && StreamHelper.isBuffered((wrappedWriter = (WrappedWriter)writer).getWrappedWriter());
    }

    @Nullable
    public static Writer getBuffered(@Nullable Writer writer) {
        return writer == null || StreamHelper.isBuffered(writer) ? writer : new NonBlockingBufferedWriter(writer);
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStream(@WillClose @Nullable InputStream inputStream, @WillNotClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(outputStream).closeTo(false).build();
    }

    @Nonnull
    public static ESuccess copyInputStreamToOutputStreamAndCloseOS(@WillClose @Nullable InputStream inputStream, @WillClose @Nullable OutputStream outputStream) {
        return StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(outputStream).closeTo(true).build();
    }

    @Nonnull
    public static CopyByteStreamBuilder copyByteStream() {
        return new CopyByteStreamBuilder();
    }

    public static int getAvailable(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                return inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Nullable
    public static NonBlockingByteArrayOutputStream getCopy(@Nonnull @WillClose InputStream inputStream) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(nonBlockingByteArrayOutputStream).closeTo(false).build().isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static NonBlockingByteArrayOutputStream getCopyWithLimit(@Nonnull @WillClose InputStream inputStream, @Nonnegative long l) {
        int n = Math.max(16384, StreamHelper.getAvailable(inputStream));
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(n);
        if (StreamHelper.copyByteStream().from(inputStream).closeFrom(true).to(nonBlockingByteArrayOutputStream).closeTo(false).limit(l).build().isFailure()) {
            return null;
        }
        return nonBlockingByteArrayOutputStream;
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable IHasInputStream iHasInputStream) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytes(iHasInputStream.getInputStream());
    }

    @Nullable
    public static byte[] getAllBytes(@Nullable @WillClose InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);){
            if (nonBlockingByteArrayOutputStream == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = nonBlockingByteArrayOutputStream.getBufferOrCopy();
            return byArray;
        }
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable IHasInputStream iHasInputStream, @Nonnull @Nonempty Charset charset) {
        if (iHasInputStream == null) {
            return null;
        }
        return StreamHelper.getAllBytesAsString(iHasInputStream.getInputStream(), charset);
    }

    @Nullable
    public static String getAllBytesAsString(@Nullable @WillClose InputStream inputStream, @Nonnull @Nonempty Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        if (inputStream == null) {
            return null;
        }
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = StreamHelper.getCopy(inputStream);){
            if (nonBlockingByteArrayOutputStream == null) {
                String string = null;
                return string;
            }
            String string = nonBlockingByteArrayOutputStream.getAsString(charset);
            return string;
        }
    }

    @Nonnull
    public static ESuccess copyReaderToWriter(@WillClose @Nullable Reader reader, @WillNotClose @Nullable Writer writer) {
        return StreamHelper.copyCharStream().from(reader).closeFrom(true).to(writer).closeTo(false).build();
    }

    @Nonnull
    public static ESuccess copyReaderToWriterAndCloseWriter(@Nullable @WillClose Reader reader, @Nullable @WillClose Writer writer) {
        return StreamHelper.copyCharStream().from(reader).closeFrom(true).to(writer).closeTo(true).build();
    }

    @Nonnull
    public static CopyCharStreamBuilder copyCharStream() {
        return new CopyCharStreamBuilder();
    }

    @Nullable
    public static NonBlockingStringWriter getCopy(@Nonnull @WillClose Reader reader) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyCharStream().from(reader).closeFrom(true).to(nonBlockingStringWriter).closeTo(false).build().isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    @Nullable
    public static NonBlockingStringWriter getCopyWithLimit(@Nonnull @WillClose Reader reader, @Nonnegative long l) {
        NonBlockingStringWriter nonBlockingStringWriter = new NonBlockingStringWriter(16384);
        if (StreamHelper.copyCharStream().from(reader).closeFrom(true).to(nonBlockingStringWriter).closeTo(false).limit(l).build().isFailure()) {
            return null;
        }
        return nonBlockingStringWriter;
    }

    @Nullable
    public static char[] getAllCharacters(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);){
            if (nonBlockingStringWriter == null) {
                char[] cArray = null;
                return cArray;
            }
            char[] cArray = nonBlockingStringWriter.getAsCharArray();
            return cArray;
        }
    }

    @Nullable
    public static String getAllCharactersAsString(@Nullable @WillClose Reader reader) {
        if (reader == null) {
            return null;
        }
        try (NonBlockingStringWriter nonBlockingStringWriter = StreamHelper.getCopy(reader);){
            if (nonBlockingStringWriter == null) {
                String string = null;
                return string;
            }
            String string = nonBlockingStringWriter.getAsString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        try {
            ValueEnforcer.notNull(outputStream, "OutputStream");
            ValueEnforcer.isArrayOfsLen(byArray, n, n2);
            outputStream.write(byArray, n, n2);
            outputStream.flush();
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write to output stream", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull byte[] byArray) {
        return StreamHelper.writeStream(outputStream, byArray, 0, byArray.length);
    }

    @Nonnull
    public static ESuccess writeStream(@WillClose @Nonnull OutputStream outputStream, @Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Content");
        ValueEnforcer.notNull(charset, "Charset");
        return StreamHelper.writeStream(outputStream, string.getBytes(charset));
    }

    public static void skipFully(@Nonnull InputStream inputStream, @Nonnegative long l) throws IOException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isGE0(l, "BytesToSkip");
        long l2 = l;
        while (l2 > 0L) {
            long l3 = inputStream.skip(l2);
            if (l3 == 0L) {
                if (inputStream.read() == -1) {
                    throw new EOFException("Failed to skip a total of " + l + " bytes on input stream. Only skipped " + (l - l2) + " bytes so far!");
                }
                --l2;
                continue;
            }
            l2 -= l3;
        }
    }

    @Nonnegative
    public static int readFully(@Nonnull InputStream inputStream, @Nonnull byte[] byArray) throws IOException {
        return StreamHelper.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Nonnegative
    public static int readFully(@Nonnull @WillNotClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws IOException {
        int n3;
        int n4;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 >= 0) continue;
            throw new EOFException("Failed to read a total of " + n2 + " bytes from input stream. Only read " + n3 + " bytes so far.");
        }
        return n3;
    }

    private static void _readUntilEOF(@Nonnull @WillNotClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(inputStream, "InputStream");
        ValueEnforcer.notNull(byArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = inputStream.read(byArray, 0, byArray.length)) > -1) {
            objIntConsumer.accept((byte[])byArray, n);
        }
    }

    public static void readUntilEOF(@Nonnull @WillClose InputStream inputStream, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(inputStream, StreamHelper.createDefaultCopyBufferBytes(), objIntConsumer);
    }

    public static void readUntilEOF(@Nonnull @WillClose InputStream inputStream, @Nonnull byte[] byArray, @Nonnull ObjIntConsumer<? super byte[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(inputStream, "InputStream");
            ValueEnforcer.notNull(byArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(inputStream, byArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    private static void _readUntilEOF(@Nonnull @WillNotClose Reader reader, @Nonnull char[] cArray, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        int n;
        ValueEnforcer.notNull(reader, "Reader");
        ValueEnforcer.notNull(cArray, "Buffer");
        ValueEnforcer.notNull(objIntConsumer, "Consumer");
        while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
            objIntConsumer.accept((char[])cArray, n);
        }
    }

    public static void readUntilEOF(@Nonnull @WillClose Reader reader, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        StreamHelper.readUntilEOF(reader, new char[16384], objIntConsumer);
    }

    public static void readUntilEOF(@Nonnull @WillClose Reader reader, @Nonnull char[] cArray, @Nonnull ObjIntConsumer<? super char[]> objIntConsumer) throws IOException {
        try {
            ValueEnforcer.notNull(reader, "Reader");
            ValueEnforcer.notNull(cArray, "Buffer");
            ValueEnforcer.notNull(objIntConsumer, "Consumer");
            StreamHelper._readUntilEOF(reader, cArray, objIntConsumer);
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    @Nullable
    public static InputStream checkForInvalidFilterInputStream(@Nullable InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.markSupported();
            }
            catch (NullPointerException nullPointerException) {
                StreamHelper.close(inputStream);
                return null;
            }
        }
        return inputStream;
    }

    public static void writeSafeUTF(@Nonnull DataOutput dataOutput, @Nullable String string) throws IOException {
        ValueEnforcer.notNull(dataOutput, "DataOutput");
        if (string == null) {
            dataOutput.writeByte(0);
        } else {
            dataOutput.writeByte(2);
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray);
            dataOutput.writeInt(-131075);
        }
    }

    @Nullable
    public static String readSafeUTF(@Nonnull DataInput dataInput) throws IOException {
        String string;
        ValueEnforcer.notNull(dataInput, "DataInput");
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                break;
            }
            case 2: {
                int n = dataInput.readInt();
                byte[] byArray = new byte[n];
                dataInput.readFully(byArray);
                string = new String(byArray, StandardCharsets.UTF_8);
                int n2 = dataInput.readInt();
                if (n2 == -131075) break;
                throw new IOException("Missing end of String marker");
            }
            default: {
                throw new IOException("Unsupported string layout version " + by);
            }
        }
        return string;
    }

    public static class CopyByteStreamBuilder
    implements IBuilder<ESuccess> {
        public static final boolean DEFAULT_CLOSE_SOURCE = false;
        public static final boolean DEFAULT_CLOSE_DESTINATION = false;
        private InputStream m_aIS;
        private boolean m_bCloseIS = false;
        private OutputStream m_aOS;
        private boolean m_bCloseOS = false;
        private byte[] m_aBuffer;
        private long m_nLimit = -1L;
        private IExceptionCallback<IOException> m_aExceptionCallback;
        private MutableLong m_aCopyByteCount;
        private LongConsumer m_aProgressCallback;

        @Nonnull
        public CopyByteStreamBuilder from(@Nullable InputStream inputStream) {
            this.m_aIS = inputStream;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder closeFrom(boolean bl) {
            this.m_bCloseIS = bl;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder to(@Nullable OutputStream outputStream) {
            this.m_aOS = outputStream;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder closeTo(boolean bl) {
            this.m_bCloseOS = bl;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder buffer(@Nullable byte[] byArray) {
            this.m_aBuffer = byArray;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder limit(long l) {
            this.m_nLimit = l;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder limit(@Nullable Long l) {
            return l == null ? this.unlimited() : this.limit((long)l);
        }

        @Nonnull
        public CopyByteStreamBuilder unlimited() {
            return this.limit(-1L);
        }

        @Nonnull
        public CopyByteStreamBuilder exceptionCallback(@Nullable IExceptionCallback<IOException> iExceptionCallback) {
            this.m_aExceptionCallback = iExceptionCallback;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder copyByteCount(@Nullable MutableLong mutableLong) {
            this.m_aCopyByteCount = mutableLong;
            return this;
        }

        @Nonnull
        public CopyByteStreamBuilder progressCallback(@Nullable LongConsumer longConsumer) {
            this.m_aProgressCallback = longConsumer;
            return this;
        }

        @Nonnegative
        private static long _copyInputStreamToOutputStream(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray, @Nullable LongConsumer longConsumer) throws IOException {
            int n;
            int n2 = byArray.length;
            long l = 0L;
            while ((n = inputStream.read(byArray, 0, n2)) > -1) {
                if (n <= 0) continue;
                outputStream.write(byArray, 0, n);
                l += (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l);
            }
            return l;
        }

        @Nonnegative
        private static long _copyInputStreamToOutputStreamWithLimit(@Nonnull @WillNotClose InputStream inputStream, @Nonnull @WillNotClose OutputStream outputStream, @Nonnull byte[] byArray, @Nonnegative long l, @Nullable LongConsumer longConsumer) throws IOException {
            int n = byArray.length;
            long l2 = l;
            long l3 = 0L;
            while (true) {
                int n2;
                int n3;
                int n4 = n3 = l2 >= (long)n ? n : (int)l2;
                if (n3 == 0 || (n2 = inputStream.read(byArray, 0, n3)) == -1) break;
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
                l3 += (long)n2;
                l2 -= (long)n2;
                if (longConsumer == null) continue;
                longConsumer.accept(l3);
            }
            return l3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public ESuccess build() {
            try {
                if (this.m_aIS == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The source InputStream is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                if (this.m_aOS == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The target OutputStream is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                byte[] byArray = this.m_aBuffer != null && this.m_aBuffer.length > 0 ? this.m_aBuffer : StreamHelper.createDefaultCopyBufferBytes();
                long l = this.m_nLimit < 0L ? CopyByteStreamBuilder._copyInputStreamToOutputStream(this.m_aIS, this.m_aOS, byArray, this.m_aProgressCallback) : CopyByteStreamBuilder._copyInputStreamToOutputStreamWithLimit(this.m_aIS, this.m_aOS, byArray, this.m_nLimit, this.m_aProgressCallback);
                if (this.m_aCopyByteCount != null) {
                    this.m_aCopyByteCount.set(l);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            catch (IOException iOException) {
                if (this.m_aExceptionCallback != null) {
                    this.m_aExceptionCallback.onException(iOException);
                } else if (!StreamHelper.isKnownEOFException(iOException)) {
                    LOGGER.error("Failed to copy from InputStream to OutputStream", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
            finally {
                if (this.m_bCloseIS) {
                    StreamHelper.close(this.m_aIS);
                }
                if (this.m_bCloseOS) {
                    StreamHelper.close(this.m_aOS);
                }
            }
            return ESuccess.FAILURE;
        }
    }

    public static class CopyCharStreamBuilder
    implements IBuilder<ESuccess> {
        public static final boolean DEFAULT_CLOSE_FROM = false;
        public static final boolean DEFAULT_CLOSE_TO = false;
        private Reader m_aReader;
        private boolean m_bCloseReader = false;
        private Writer m_aWriter;
        private boolean m_bCloseWriter = false;
        private char[] m_aBuffer;
        private long m_nLimit = -1L;
        private IExceptionCallback<IOException> m_aExceptionCallback;
        private MutableLong m_aCopyCharCount;
        private LongConsumer m_aProgressCallback;

        @Nonnull
        public CopyCharStreamBuilder from(@Nullable Reader reader) {
            this.m_aReader = reader;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder closeFrom(boolean bl) {
            this.m_bCloseReader = bl;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder to(@Nullable Writer writer) {
            this.m_aWriter = writer;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder closeTo(boolean bl) {
            this.m_bCloseWriter = bl;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder buffer(@Nullable char[] cArray) {
            this.m_aBuffer = cArray;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder limit(long l) {
            this.m_nLimit = l;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder limit(@Nullable Long l) {
            return l == null ? this.unlimited() : this.limit((long)l);
        }

        @Nonnull
        public CopyCharStreamBuilder unlimited() {
            return this.limit(-1L);
        }

        @Nonnull
        public CopyCharStreamBuilder exceptionCallback(@Nullable IExceptionCallback<IOException> iExceptionCallback) {
            this.m_aExceptionCallback = iExceptionCallback;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder copyCharCount(@Nullable MutableLong mutableLong) {
            this.m_aCopyCharCount = mutableLong;
            return this;
        }

        @Nonnull
        public CopyCharStreamBuilder progressCallback(@Nullable LongConsumer longConsumer) {
            this.m_aProgressCallback = longConsumer;
            return this;
        }

        @Nonnegative
        private static long _copyReaderToWriter(@Nonnull @WillNotClose Reader reader, @Nonnull @WillNotClose Writer writer, @Nonnull char[] cArray, @Nullable LongConsumer longConsumer) throws IOException {
            int n;
            long l = 0L;
            while ((n = reader.read(cArray, 0, cArray.length)) > -1) {
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
                l += (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l);
            }
            return l;
        }

        @Nonnegative
        private static long _copyReaderToWriterWithLimit(@Nonnull @WillNotClose Reader reader, @Nonnull @WillNotClose Writer writer, @Nonnull char[] cArray, @Nonnegative long l, @Nullable LongConsumer longConsumer) throws IOException {
            long l2 = l;
            long l3 = 0L;
            while (true) {
                int n;
                int n2;
                int n3 = n2 = l2 >= (long)cArray.length ? cArray.length : (int)l2;
                if (n2 == 0 || (n = reader.read(cArray, 0, n2)) == -1) break;
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
                l3 += (long)n;
                l2 -= (long)n;
                if (longConsumer == null) continue;
                longConsumer.accept(l3);
            }
            return l3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public ESuccess build() {
            try {
                if (this.m_aReader == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The source Reader is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                if (this.m_aWriter == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("The target Writer is not set - hence no copying is possible");
                    }
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                char[] cArray = this.m_aBuffer != null && this.m_aBuffer.length > 0 ? this.m_aBuffer : StreamHelper.createDefaultCopyBufferChars();
                long l = this.m_nLimit < 0L ? CopyCharStreamBuilder._copyReaderToWriter(this.m_aReader, this.m_aWriter, cArray, this.m_aProgressCallback) : CopyCharStreamBuilder._copyReaderToWriterWithLimit(this.m_aReader, this.m_aWriter, cArray, this.m_nLimit, this.m_aProgressCallback);
                if (this.m_aCopyCharCount != null) {
                    this.m_aCopyCharCount.set(l);
                }
                ESuccess eSuccess = ESuccess.SUCCESS;
                return eSuccess;
            }
            catch (IOException iOException) {
                if (this.m_aExceptionCallback != null) {
                    this.m_aExceptionCallback.onException(iOException);
                } else if (!StreamHelper.isKnownEOFException(iOException)) {
                    LOGGER.error("Failed to copy from Reader to Writer", (Throwable)StreamHelper.internalGetPropagatableException(iOException));
                }
            }
            finally {
                if (this.m_bCloseReader) {
                    StreamHelper.close(this.m_aReader);
                }
                if (this.m_bCloseWriter) {
                    StreamHelper.close(this.m_aWriter);
                }
            }
            return ESuccess.FAILURE;
        }
    }
}

