/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.EncodeException;
import com.helger.base.codec.IByteArrayCodec;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;

@NotThreadSafe
public class QuotedPrintableCodec
implements IByteArrayCodec {
    public static final byte ESCAPE_CHAR = 61;
    public static final byte TAB = 9;
    public static final byte SPACE = 32;
    private static final BitSet PRINTABLE_CHARS = new BitSet(256);
    private final BitSet m_aPrintableChars;

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultPrintableChars() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public QuotedPrintableCodec() {
        this(PRINTABLE_CHARS);
    }

    public QuotedPrintableCodec(@Nonnull BitSet bitSet) {
        this.m_aPrintableChars = (BitSet)bitSet.clone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public BitSet getPrintableChars() {
        return (BitSet)this.m_aPrintableChars.clone();
    }

    public static final void writeEncodeQuotedPrintableByte(int n, @Nonnull OutputStream outputStream) throws IOException {
        char c = StringHex.getHexCharUpperCase(n >> 4 & 0xF);
        char c2 = StringHex.getHexCharUpperCase(n & 0xF);
        outputStream.write(61);
        outputStream.write(c);
        outputStream.write(c2);
    }

    @Override
    public void encode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            for (int i = 0; i < n2; ++i) {
                int n3 = byArray[n + i] & 0xFF;
                if (this.m_aPrintableChars.get(n3)) {
                    outputStream.write(n3);
                    continue;
                }
                QuotedPrintableCodec.writeEncodeQuotedPrintableByte(n3, outputStream);
            }
        }
        catch (IOException iOException) {
            throw new EncodeException("Failed to encode quoted-printable", iOException);
        }
    }

    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[n + i];
                if (by == 61) {
                    if (i >= n2 - 2) {
                        throw new DecodeException("Invalid quoted-printable encoding. Premature end of input after escape char");
                    }
                    char c = (char)byArray[n + i + 1];
                    char c2 = (char)byArray[n + i + 2];
                    i += 2;
                    int n3 = StringHex.getHexByte(c, c2);
                    if (n3 < 0) {
                        throw new DecodeException("Invalid quoted-printable encoding for " + c + " and " + c2);
                    }
                    outputStream.write(n3);
                    continue;
                }
                outputStream.write(by);
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode quoted-printable", iOException);
        }
    }

    static {
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
        for (int i = 33; i <= 126; ++i) {
            if (i == 61) continue;
            PRINTABLE_CHARS.set(i);
        }
    }
}

