/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.type;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.base.type.ITypedObject;
import com.helger.base.type.ObjectType;
import jakarta.annotation.Nonnull;

@Immutable
public final class TypedObject<IDTYPE>
implements ITypedObject<IDTYPE> {
    private final ObjectType m_aObjectType;
    private final IDTYPE m_aID;

    public TypedObject(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        this(iTypedObject.getObjectType(), iTypedObject.getID());
    }

    public TypedObject(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        this.m_aObjectType = ValueEnforcer.notNull(objectType, "ObjectType");
        this.m_aID = ValueEnforcer.notNull(IDTYPE, "ID");
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return this.m_aObjectType;
    }

    @Override
    @Nonnull
    public IDTYPE getID() {
        return this.m_aID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TypedObject typedObject = (TypedObject)object;
        return this.m_aObjectType.equals(typedObject.m_aObjectType) && this.m_aID.equals(typedObject.m_aID);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aObjectType).append(this.m_aID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("ObjectType", this.m_aObjectType).append("ID", this.m_aID).getToString();
    }

    @Nonnull
    public static <IDTYPE> TypedObject<IDTYPE> create(@Nonnull ITypedObject<IDTYPE> iTypedObject) {
        return new TypedObject<IDTYPE>(iTypedObject);
    }

    @Nonnull
    public static <IDTYPE> TypedObject<IDTYPE> create(@Nonnull ObjectType objectType, @Nonnull IDTYPE IDTYPE) {
        return new TypedObject<IDTYPE>(objectType, IDTYPE);
    }
}

