/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.lang;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.CGlobal;
import com.helger.base.array.ArrayHelper;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.id.IHasID;
import com.helger.base.id.IHasIntID;
import com.helger.base.name.IHasName;
import com.helger.base.reflection.GenericReflection;
import com.helger.base.state.EChange;
import com.helger.base.string.StringHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class EnumHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumHelper.class);
    private static final Object[] NOT_CACHABLE = CGlobal.EMPTY_OBJECT_ARRAY;
    private static final SimpleReadWriteLock RW_LOCK_INTCACHE = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK_INTCACHE")
    private static final Map<String, Object[]> INT_CACHE = new HashMap<String, Object[]>();
    private static final EnumHelper INSTANCE = new EnumHelper();

    private EnumHelper() {
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE findFirst(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate) {
        return EnumHelper.findFirst(clazz, predicate, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE findFirst(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate, @Nullable ENUMTYPE ENUMTYPE) {
        return (ENUMTYPE)((Enum)ArrayHelper.findFirst((Enum[])clazz.getEnumConstants(), predicate, ENUMTYPE));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ENUMTYPE extends Enum<ENUMTYPE>> List<ENUMTYPE> getAll(@Nonnull Class<ENUMTYPE> clazz, @Nullable Predicate<? super ENUMTYPE> predicate) {
        if (predicate == null) {
            return Arrays.asList((Enum[])clazz.getEnumConstants());
        }
        ArrayList<Enum> arrayList = new ArrayList<Enum>();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (!predicate.test(enum_)) continue;
            arrayList.add(enum_);
        }
        return arrayList;
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        return EnumHelper.getFromIDOrDefault(clazz, KEYTYPE, null);
    }

    @Nullable
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (KEYTYPE == null) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasID)((Object)enum_)).getID().equals(KEYTYPE), ENUMTYPE);
    }

    @Nonnull
    public static <KEYTYPE, ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable KEYTYPE KEYTYPE) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, KEYTYPE);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + String.valueOf(KEYTYPE) + " within class " + String.valueOf(clazz));
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromIDCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (string == null) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((String)((IHasID)((Object)enum_)).getID()).equalsIgnoreCase(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + string + " within class " + String.valueOf(clazz));
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrNull(@Nonnull Class<ENUMTYPE> clazz, int n) {
        return EnumHelper.getFromIDOrDefault(clazz, n, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrDefault(@Nonnull Class<ENUMTYPE> clazz, int n, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        String string = clazz.getName();
        Object[] objectArray = RW_LOCK_INTCACHE.readLockedGet(() -> INT_CACHE.get(string));
        if (objectArray == null) {
            objectArray = RW_LOCK_INTCACHE.writeLockedGet(() -> {
                Object[] objectArray = INT_CACHE.get(string);
                if (objectArray == null) {
                    int n = Integer.MAX_VALUE;
                    int n2 = Integer.MIN_VALUE;
                    for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                        int n3 = ((IHasIntID)((Object)enum_)).getID();
                        if (n3 < n) {
                            n = n3;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                    if (n >= 0 && n2 <= 255) {
                        objectArray = new Object[n2 + 1];
                        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
                            objectArray[((IHasIntID)((Object)enum_)).getID()] = enum_;
                        }
                    } else {
                        objectArray = NOT_CACHABLE;
                    }
                    INT_CACHE.put(string, objectArray);
                }
                return objectArray;
            });
        }
        if (objectArray != NOT_CACHABLE) {
            if (n < 0 || n >= objectArray.length) {
                return ENUMTYPE;
            }
            return (ENUMTYPE)((Enum)GenericReflection.uncheckedCast(objectArray[n]));
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasIntID)((Object)enum_)).getID() == n, ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromIDOrThrow(@Nonnull Class<ENUMTYPE> clazz, int n) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromIDOrNull(clazz, n);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve ID " + n + " within class " + String.valueOf(clazz));
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.isEmpty(string)) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasName)((Object)enum_)).getName().equals(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + String.valueOf(clazz));
        }
        return ENUMTYPE;
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrNull(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        return EnumHelper.getFromNameCaseInsensitiveOrDefault(clazz, string, null);
    }

    @Nullable
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrDefault(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string, @Nullable ENUMTYPE ENUMTYPE) {
        ValueEnforcer.notNull(clazz, "Class");
        if (StringHelper.isEmpty(string)) {
            return ENUMTYPE;
        }
        return (ENUMTYPE)EnumHelper.findFirst(clazz, enum_ -> ((IHasName)((Object)enum_)).getName().equalsIgnoreCase(string), ENUMTYPE);
    }

    @Nonnull
    public static <ENUMTYPE extends Enum<ENUMTYPE>> ENUMTYPE getFromNameCaseInsensitiveOrThrow(@Nonnull Class<ENUMTYPE> clazz, @Nullable String string) {
        ENUMTYPE ENUMTYPE = EnumHelper.getFromNameCaseInsensitiveOrNull(clazz, string);
        if (ENUMTYPE == null) {
            throw new IllegalArgumentException("Failed to resolve name " + string + " within class " + String.valueOf(clazz));
        }
        return ENUMTYPE;
    }

    @Nonnull
    public static String getEnumID(@Nonnull Enum<?> enum_) {
        return enum_.getClass().getName() + "." + enum_.name();
    }

    @Nonnull
    public static EChange clearCache() {
        return RW_LOCK_INTCACHE.writeLockedGet(() -> {
            if (INT_CACHE.isEmpty()) {
                return EChange.UNCHANGED;
            }
            INT_CACHE.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cache was cleared: " + EnumHelper.class.getName());
            }
            return EChange.CHANGED;
        });
    }
}

