/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.stream;

import com.helger.base.concurrent.SimpleLock;
import com.helger.base.io.nonblocking.NonBlockingBitInputStream;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class BitInputStream
extends NonBlockingBitInputStream {
    private final SimpleLock m_aLock = new SimpleLock();

    public BitInputStream(@Nonnull InputStream inputStream, @Nonnull ByteOrder byteOrder) {
        super(inputStream, byteOrder);
    }

    @Override
    public int readBit() throws IOException {
        this.m_aLock.lock();
        try {
            int n = super.readBit();
            return n;
        }
        finally {
            this.m_aLock.unlock();
        }
    }

    @Override
    public void close() {
        this.m_aLock.locked(() -> super.close());
    }
}

