/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.enforce;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.base.equals.EqualsHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class ValueEnforcer {
    public static final boolean DEFAULT_ENABLED = true;
    private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueEnforcer.class);
    private static final ValueEnforcer INSTANCE = new ValueEnforcer();

    private ValueEnforcer() {
    }

    public static boolean isEnabled() {
        return ENABLED.get();
    }

    public static void setEnabled(boolean bl) {
        boolean bl2 = ENABLED.get();
        ENABLED.set(bl);
        if (bl2 != bl) {
            LOGGER.info("ValueEnforcer checks are now " + (bl ? "enabled" : "disabled"));
        }
    }

    public static void isTrue(boolean bl, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isTrue(bl, () -> string);
        }
    }

    public static void isTrue(boolean bl, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && !bl) {
            throw new IllegalArgumentException("The expression must be true but it is not: " + supplier.get());
        }
    }

    public static void isTrue(@Nonnull BooleanSupplier booleanSupplier, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isTrue(booleanSupplier, () -> string);
        }
    }

    public static void isTrue(@Nonnull BooleanSupplier booleanSupplier, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && !booleanSupplier.getAsBoolean()) {
            throw new IllegalArgumentException("The expression must be true but it is not: " + supplier.get());
        }
    }

    public static void isFalse(boolean bl, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isFalse(bl, () -> string);
        }
    }

    public static void isFalse(boolean bl, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && bl) {
            throw new IllegalArgumentException("The expression must be false but it is not: " + supplier.get());
        }
    }

    public static void isFalse(@Nonnull BooleanSupplier booleanSupplier, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isFalse(booleanSupplier, () -> string);
        }
    }

    public static void isFalse(@Nonnull BooleanSupplier booleanSupplier, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && booleanSupplier.getAsBoolean()) {
            throw new IllegalArgumentException("The expression must be false but it is not: " + supplier.get());
        }
    }

    public static <T> void isInstanceOf(@Nullable T t, @Nonnull Class<? extends T> clazz, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isInstanceOf(t, clazz, () -> string);
        }
    }

    public static <T> void isInstanceOf(@Nullable T t, @Nonnull Class<? extends T> clazz, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(clazz, "Class");
        if (ValueEnforcer.isEnabled() && t != null && !clazz.isInstance(t)) {
            throw new IllegalArgumentException(supplier.get() + " must be of class " + clazz.getName() + " but is of type " + t.getClass().getName());
        }
    }

    public static <T> T notNull(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled() && t == null) {
            throw new NullPointerException("The value of '" + string + "' may not be null!");
        }
        return t;
    }

    public static <T> T notNull(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && t == null) {
            throw new NullPointerException("The value of '" + supplier.get() + "' may not be null!");
        }
        return t;
    }

    public static void isNull(@Nullable Object object, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isNull(object, () -> string);
        }
    }

    public static void isNull(@Nullable Object object, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && object != null) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be null but is " + String.valueOf(object));
        }
    }

    public static <T extends CharSequence> T notEmpty(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(t, () -> string);
        }
        return t;
    }

    public static <T extends CharSequence> T notEmpty(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        if (ValueEnforcer.isEnabled() && t.length() == 0) {
            throw new IllegalArgumentException("The value of the string '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    public static <T> T[] notEmpty(@Nonnull T[] TArray, @Nonnull String string) {
        return ValueEnforcer.notEmpty(TArray, () -> string);
    }

    public static <T> T[] notEmpty(@Nonnull T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(TArray, supplier);
        if (ValueEnforcer.isEnabled() && TArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return TArray;
    }

    public static boolean[] notEmpty(@Nonnull boolean[] blArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(blArray, () -> string);
        }
        return blArray;
    }

    public static boolean[] notEmpty(@Nonnull boolean[] blArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(blArray, supplier);
        if (ValueEnforcer.isEnabled() && blArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return blArray;
    }

    public static byte[] notEmpty(@Nonnull byte[] byArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(byArray, () -> string);
        }
        return byArray;
    }

    public static byte[] notEmpty(@Nonnull byte[] byArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(byArray, supplier);
        if (ValueEnforcer.isEnabled() && byArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return byArray;
    }

    public static char[] notEmpty(@Nonnull char[] cArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(cArray, () -> string);
        }
        return cArray;
    }

    public static char[] notEmpty(@Nonnull char[] cArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(cArray, supplier);
        if (ValueEnforcer.isEnabled() && cArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return cArray;
    }

    public static double[] notEmpty(@Nonnull double[] dArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(dArray, () -> string);
        }
        return dArray;
    }

    public static double[] notEmpty(@Nonnull double[] dArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(dArray, supplier);
        if (ValueEnforcer.isEnabled() && dArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return dArray;
    }

    public static float[] notEmpty(@Nonnull float[] fArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(fArray, () -> string);
        }
        return fArray;
    }

    public static float[] notEmpty(@Nonnull float[] fArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(fArray, supplier);
        if (ValueEnforcer.isEnabled() && fArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return fArray;
    }

    public static int[] notEmpty(@Nonnull int[] nArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(nArray, () -> string);
        }
        return nArray;
    }

    public static int[] notEmpty(@Nonnull int[] nArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(nArray, supplier);
        if (ValueEnforcer.isEnabled() && nArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return nArray;
    }

    public static long[] notEmpty(@Nonnull long[] lArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(lArray, () -> string);
        }
        return lArray;
    }

    public static long[] notEmpty(@Nonnull long[] lArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(lArray, supplier);
        if (ValueEnforcer.isEnabled() && lArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return lArray;
    }

    public static short[] notEmpty(@Nonnull short[] sArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(sArray, () -> string);
        }
        return sArray;
    }

    public static short[] notEmpty(@Nonnull short[] sArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(sArray, supplier);
        if (ValueEnforcer.isEnabled() && sArray.length == 0) {
            throw new IllegalArgumentException("The value of the array '" + supplier.get() + "' may not be empty!");
        }
        return sArray;
    }

    @CodingStyleguideUnaware
    public static <T extends Collection<?>> T notEmpty(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(t, () -> string);
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Collection<?>> T notEmpty(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        if (ValueEnforcer.isEnabled() && t.isEmpty()) {
            throw new IllegalArgumentException("The value of the collection '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Iterable<?>> T notEmpty(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(t, () -> string);
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Iterable<?>> T notEmpty(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        if (ValueEnforcer.isEnabled() && !t.iterator().hasNext()) {
            throw new IllegalArgumentException("The value of the iterable '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notEmpty(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmpty(t, () -> string);
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notEmpty(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        if (ValueEnforcer.isEnabled() && t.isEmpty()) {
            throw new IllegalArgumentException("The value of the map '" + supplier.get() + "' may not be empty!");
        }
        return t;
    }

    @Nullable
    public static <T> T[] noNullValue(@Nonnull T[] TArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.noNullValue(TArray, () -> string);
        }
        return TArray;
    }

    @Nullable
    public static <T> T[] noNullValue(@Nonnull T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && TArray != null) {
            int n = 0;
            for (T t : TArray) {
                if (t == null) {
                    throw new IllegalArgumentException("Item " + n + " of array '" + supplier.get() + "' may not be null!");
                }
                ++n;
            }
        }
        return TArray;
    }

    @Nullable
    public static <T extends Iterable<?>> T noNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.noNullValue(t, () -> string);
        }
        return t;
    }

    @Nullable
    public static <T extends Iterable<?>> T noNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && t != null) {
            int n = 0;
            for (Object obj : t) {
                if (obj == null) {
                    throw new IllegalArgumentException("Item " + n + " of iterable '" + supplier.get() + "' may not be null!");
                }
                ++n;
            }
        }
        return t;
    }

    @Nullable
    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T noNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.noNullValue(t, () -> string);
        }
        return t;
    }

    @Nullable
    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T noNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && t != null) {
            for (Map.Entry<?, ?> entry : t.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("A key of map '" + supplier.get() + "' may not be null!");
                }
                if (entry.getValue() != null) continue;
                throw new IllegalArgumentException("A value of map '" + supplier.get() + "' may not be null!");
            }
        }
        return t;
    }

    public static <T> T[] notNullNoNullValue(@Nonnull T[] TArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notNullNoNullValue(TArray, () -> string);
        }
        return TArray;
    }

    public static <T> T[] notNullNoNullValue(@Nonnull T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(TArray, supplier);
        ValueEnforcer.noNullValue(TArray, supplier);
        return TArray;
    }

    public static <T extends Iterable<?>> T notNullNoNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notNullNoNullValue(t, () -> string);
        }
        return t;
    }

    public static <T extends Iterable<?>> T notNullNoNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        ValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notNullNoNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notNullNoNullValue(t, () -> string);
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notNullNoNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(t, supplier);
        ValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T> T[] notEmptyNoNullValue(@Nonnull T[] TArray, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmptyNoNullValue(TArray, () -> string);
        }
        return TArray;
    }

    public static <T> T[] notEmptyNoNullValue(@Nonnull T[] TArray, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notEmpty(TArray, supplier);
        ValueEnforcer.noNullValue(TArray, supplier);
        return TArray;
    }

    public static <T extends Iterable<?>> T notEmptyNoNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmptyNoNullValue(t, () -> string);
        }
        return t;
    }

    public static <T extends Iterable<?>> T notEmptyNoNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notEmpty(t, supplier);
        ValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notEmptyNoNullValue(@Nonnull T t, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notEmptyNoNullValue(t, () -> string);
        }
        return t;
    }

    @CodingStyleguideUnaware
    public static <T extends Map<?, ?>> T notEmptyNoNullValue(@Nonnull T t, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notEmpty(t, supplier);
        ValueEnforcer.noNullValue(t, supplier);
        return t;
    }

    public static <T> T notNullNotEquals(@Nonnull T t, @Nonnull String string, @Nonnull T t2) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notNullNotEquals(t, () -> string, t2);
        }
        return t;
    }

    public static <T> T notNullNotEquals(@Nonnull T t, @Nonnull Supplier<? extends String> supplier, @Nonnull T t2) {
        ValueEnforcer.notNull(t, supplier);
        ValueEnforcer.notNull(t2, "UnexpectedValue");
        if (ValueEnforcer.isEnabled() && t.equals(t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' may not be equal to " + String.valueOf(t2) + "!");
        }
        return t;
    }

    public static <T> T notNullAndEquals(@Nonnull T t, @Nonnull String string, @Nonnull T t2) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.notNullAndEquals(t, () -> string, t2);
        }
        return t;
    }

    public static <T> T notNullAndEquals(@Nonnull T t, @Nonnull Supplier<? extends String> supplier, @Nonnull T t2) {
        ValueEnforcer.notNull(t, supplier);
        if (ValueEnforcer.isEnabled() && !t.equals(t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + String.valueOf(t) + " -- Expected value: " + String.valueOf(t2));
        }
        return t;
    }

    public static <T> T isSame(@Nullable T t, @Nonnull String string, @Nullable T t2) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isSame(t, () -> string, t2);
        }
        return t;
    }

    public static <T> T isSame(@Nullable T t, @Nonnull Supplier<? extends String> supplier, @Nullable T t2) {
        if (ValueEnforcer.isEnabled() && EqualsHelper.identityDifferent(t, t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + String.valueOf(t) + " -- Expected value: " + String.valueOf(t2));
        }
        return t;
    }

    public static <T> T isEqual(T t, @Nullable T t2, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isEqual(t, t2, () -> string);
        }
        return t;
    }

    public static <T> T isEqual(T t, @Nullable T t2, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && !EqualsHelper.equals(t, t2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + String.valueOf(t) + " -- Expected value: " + String.valueOf(t2));
        }
        return t;
    }

    public static void isEqual(int n, int n2, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isEqual(n, n2, () -> string);
        }
    }

    public static void isEqual(int n, int n2, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n != n2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + n + " -- Expected value: " + n2);
        }
    }

    public static void isEqual(long l, long l2, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isEqual(l, l2, () -> string);
        }
    }

    public static void isEqual(long l, long l2, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l != l2) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + l + " -- Expected value: " + l2);
        }
    }

    public static void isEqual(double d, double d2, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            ValueEnforcer.isEqual(d, d2, () -> string);
        }
    }

    public static void isEqual(double d, double d2, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && !EqualsHelper.equals(d, d2)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' does not match the expected value. Passed value: " + d + " -- Expected value: " + d2);
        }
    }

    public static int isGE0(int n, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(n, () -> string);
        }
        return n;
    }

    public static int isGE0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGE0(long l, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(l, () -> string);
        }
        return l;
    }

    public static long isGE0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l < 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + l);
        }
        return l;
    }

    public static short isGE0(short s, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(s, () -> string);
        }
        return s;
    }

    public static short isGE0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && s < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + s);
        }
        return s;
    }

    public static double isGE0(double d, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(d, () -> string);
        }
        return d;
    }

    public static double isGE0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && d < 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGE0(float f, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(f, () -> string);
        }
        return f;
    }

    public static float isGE0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && f < 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isGE0(@Nonnull BigDecimal bigDecimal, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(bigDecimal, () -> string);
        }
        return bigDecimal;
    }

    public static BigDecimal isGE0(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        if (ValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isGE0(@Nonnull BigInteger bigInteger, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGE0(bigInteger, () -> string);
        }
        return bigInteger;
    }

    public static BigInteger isGE0(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigInteger, supplier);
        if (ValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= 0! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isGT0(int n, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(n, () -> string);
        }
        return n;
    }

    public static int isGT0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + n);
        }
        return n;
    }

    public static long isGT0(long l, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(l, () -> string);
        }
        return l;
    }

    public static long isGT0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l <= 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + l);
        }
        return l;
    }

    public static short isGT0(short s, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(s, () -> string);
        }
        return s;
    }

    public static short isGT0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && s <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + s);
        }
        return s;
    }

    public static double isGT0(double d, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(d, () -> string);
        }
        return d;
    }

    public static double isGT0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && d <= 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + d);
        }
        return d;
    }

    public static float isGT0(float f, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(f, () -> string);
        }
        return f;
    }

    public static float isGT0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && f <= 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isGT0(@Nonnull BigDecimal bigDecimal, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(bigDecimal, () -> string);
        }
        return bigDecimal;
    }

    public static BigDecimal isGT0(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        if (ValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isGT0(@Nonnull BigInteger bigInteger, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isGT0(bigInteger, () -> string);
        }
        return bigInteger;
    }

    public static BigInteger isGT0(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigInteger, supplier);
        if (ValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > 0! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isNE0(int n, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isNE0(n, () -> string);
        }
        return n;
    }

    public static int isNE0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n == 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must not be 0! The current value is: " + n);
        }
        return n;
    }

    public static long isNE0(long l, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isNE0(l, () -> string);
        }
        return l;
    }

    public static long isNE0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l == 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must not be 0! The current value is: " + l);
        }
        return l;
    }

    public static double isNE0(double d, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isNE0(d, () -> string);
        }
        return d;
    }

    public static double isNE0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && d == 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must not be 0! The current value is: " + d);
        }
        return d;
    }

    public static BigDecimal isNE0(@Nonnull BigDecimal bigDecimal, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isNE0(bigDecimal, () -> string);
        }
        return bigDecimal;
    }

    public static BigDecimal isNE0(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        if (ValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must not be 0! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isNE0(@Nonnull BigInteger bigInteger, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isNE0(bigInteger, () -> string);
        }
        return bigInteger;
    }

    public static BigInteger isNE0(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigInteger, supplier);
        if (ValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) == 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must not be 0! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isLE0(int n, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(n, () -> string);
        }
        return n;
    }

    public static int isLE0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + n);
        }
        return n;
    }

    public static long isLE0(long l, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(l, () -> string);
        }
        return l;
    }

    public static long isLE0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l > 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + l);
        }
        return l;
    }

    public static short isLE0(short s, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(s, () -> string);
        }
        return s;
    }

    public static short isLE0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && s > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + s);
        }
        return s;
    }

    public static double isLE0(double d, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(d, () -> string);
        }
        return d;
    }

    public static double isLE0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && d > 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + d);
        }
        return d;
    }

    public static float isLE0(float f, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(f, () -> string);
        }
        return f;
    }

    public static float isLE0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && f > 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isLE0(@Nonnull BigDecimal bigDecimal, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(bigDecimal, () -> string);
        }
        return bigDecimal;
    }

    public static BigDecimal isLE0(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        if (ValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isLE0(@Nonnull BigInteger bigInteger, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLE0(bigInteger, () -> string);
        }
        return bigInteger;
    }

    public static BigInteger isLE0(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigInteger, supplier);
        if (ValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) > 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be <= 0! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isLT0(int n, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(n, () -> string);
        }
        return n;
    }

    public static int isLT0(int n, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && n >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + n);
        }
        return n;
    }

    public static long isLT0(long l, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(l, () -> string);
        }
        return l;
    }

    public static long isLT0(long l, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && l >= 0L) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + l);
        }
        return l;
    }

    public static short isLT0(short s, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(s, () -> string);
        }
        return s;
    }

    public static short isLT0(short s, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && s >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + s);
        }
        return s;
    }

    public static double isLT0(double d, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(d, () -> string);
        }
        return d;
    }

    public static double isLT0(double d, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && d >= 0.0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + d);
        }
        return d;
    }

    public static float isLT0(float f, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(f, () -> string);
        }
        return f;
    }

    public static float isLT0(float f, @Nonnull Supplier<? extends String> supplier) {
        if (ValueEnforcer.isEnabled() && f >= 0.0f) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isLT0(@Nonnull BigDecimal bigDecimal, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(bigDecimal, () -> string);
        }
        return bigDecimal;
    }

    public static BigDecimal isLT0(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        if (ValueEnforcer.isEnabled() && bigDecimal.compareTo(BigDecimal.ZERO) >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isLT0(@Nonnull BigInteger bigInteger, @Nonnull String string) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isLT0(bigInteger, () -> string);
        }
        return bigInteger;
    }

    public static BigInteger isLT0(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier) {
        ValueEnforcer.notNull(bigInteger, supplier);
        if (ValueEnforcer.isEnabled() && bigInteger.compareTo(BigInteger.ZERO) >= 0) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be < 0! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isBetweenInclusive(int n, @Nonnull String string, int n2, int n3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(n, () -> string, n2, n3);
        }
        return n;
    }

    public static int isBetweenInclusive(int n, @Nonnull Supplier<? extends String> supplier, int n2, int n3) {
        if (ValueEnforcer.isEnabled() && (n < n2 || n > n3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + n2 + " and <= " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenInclusive(long l, @Nonnull String string, long l2, long l3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(l, () -> string, l2, l3);
        }
        return l;
    }

    public static long isBetweenInclusive(long l, @Nonnull Supplier<? extends String> supplier, long l2, long l3) {
        if (ValueEnforcer.isEnabled() && (l < l2 || l > l3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + l2 + " and <= " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static short isBetweenInclusive(short s, @Nonnull String string, short s2, short s3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(s, () -> string, s2, s3);
        }
        return s;
    }

    public static short isBetweenInclusive(short s, @Nonnull Supplier<? extends String> supplier, short s2, short s3) {
        if (ValueEnforcer.isEnabled() && (s < s2 || s > s3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + s2 + " and <= " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static double isBetweenInclusive(double d, @Nonnull String string, double d2, double d3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(d, () -> string, d2, d3);
        }
        return d;
    }

    public static double isBetweenInclusive(double d, @Nonnull Supplier<? extends String> supplier, double d2, double d3) {
        if (ValueEnforcer.isEnabled() && (d < d2 || d > d3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + d2 + " and <= " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static float isBetweenInclusive(float f, @Nonnull String string, float f2, float f3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(f, () -> string, f2, f3);
        }
        return f;
    }

    public static float isBetweenInclusive(float f, @Nonnull Supplier<? extends String> supplier, float f2, float f3) {
        if (ValueEnforcer.isEnabled() && (f < f2 || f > f3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + f2 + " and <= " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isBetweenInclusive(@Nonnull BigDecimal bigDecimal, @Nonnull String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(bigDecimal, () -> string, bigDecimal2, bigDecimal3);
        }
        return bigDecimal;
    }

    public static BigDecimal isBetweenInclusive(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        ValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (ValueEnforcer.isEnabled() && (bigDecimal.compareTo(bigDecimal2) < 0 || bigDecimal.compareTo(bigDecimal3) > 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + String.valueOf(bigDecimal2) + " and <= " + String.valueOf(bigDecimal3) + "! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenInclusive(@Nonnull BigInteger bigInteger, @Nonnull String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenInclusive(bigInteger, () -> string, bigInteger2, bigInteger3);
        }
        return bigInteger;
    }

    public static BigInteger isBetweenInclusive(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        ValueEnforcer.notNull(bigInteger, supplier);
        ValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (ValueEnforcer.isEnabled() && (bigInteger.compareTo(bigInteger2) < 0 || bigInteger.compareTo(bigInteger3) > 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be >= " + String.valueOf(bigInteger2) + " and <= " + String.valueOf(bigInteger3) + "! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    public static int isBetweenExclusive(int n, @Nonnull String string, int n2, int n3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(n, () -> string, n2, n3);
        }
        return n;
    }

    public static int isBetweenExclusive(int n, @Nonnull Supplier<? extends String> supplier, int n2, int n3) {
        if (ValueEnforcer.isEnabled() && (n <= n2 || n >= n3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + n2 + " and < " + n3 + "! The current value is: " + n);
        }
        return n;
    }

    public static long isBetweenExclusive(long l, @Nonnull String string, long l2, long l3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(l, () -> string, l2, l3);
        }
        return l;
    }

    public static long isBetweenExclusive(long l, @Nonnull Supplier<? extends String> supplier, long l2, long l3) {
        if (ValueEnforcer.isEnabled() && (l <= l2 || l >= l3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + l2 + " and < " + l3 + "! The current value is: " + l);
        }
        return l;
    }

    public static short isBetweenExclusive(short s, @Nonnull String string, short s2, short s3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(s, () -> string, s2, s3);
        }
        return s;
    }

    public static short isBetweenExclusive(short s, @Nonnull Supplier<? extends String> supplier, short s2, short s3) {
        if (ValueEnforcer.isEnabled() && (s <= s2 || s >= s3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + s2 + " and < " + s3 + "! The current value is: " + s);
        }
        return s;
    }

    public static double isBetweenExclusive(double d, @Nonnull String string, double d2, double d3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(d, () -> string, d2, d3);
        }
        return d;
    }

    public static double isBetweenExclusive(double d, @Nonnull Supplier<? extends String> supplier, double d2, double d3) {
        if (ValueEnforcer.isEnabled() && (d <= d2 || d >= d3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + d2 + " and < " + d3 + "! The current value is: " + d);
        }
        return d;
    }

    public static float isBetweenExclusive(float f, @Nonnull String string, float f2, float f3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(f, () -> string, f2, f3);
        }
        return f;
    }

    public static float isBetweenExclusive(float f, @Nonnull Supplier<? extends String> supplier, float f2, float f3) {
        if (ValueEnforcer.isEnabled() && (f <= f2 || f >= f3)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + f2 + " and < " + f3 + "! The current value is: " + f);
        }
        return f;
    }

    public static BigDecimal isBetweenExclusive(@Nonnull BigDecimal bigDecimal, @Nonnull String string, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(bigDecimal, () -> string, bigDecimal2, bigDecimal3);
        }
        return bigDecimal;
    }

    public static BigDecimal isBetweenExclusive(@Nonnull BigDecimal bigDecimal, @Nonnull Supplier<? extends String> supplier, @Nonnull BigDecimal bigDecimal2, @Nonnull BigDecimal bigDecimal3) {
        ValueEnforcer.notNull(bigDecimal, supplier);
        ValueEnforcer.notNull(bigDecimal2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigDecimal3, "UpperBoundInclusive");
        if (ValueEnforcer.isEnabled() && (bigDecimal.compareTo(bigDecimal2) <= 0 || bigDecimal.compareTo(bigDecimal3) >= 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + String.valueOf(bigDecimal2) + " and < " + String.valueOf(bigDecimal3) + "! The current value is: " + String.valueOf(bigDecimal));
        }
        return bigDecimal;
    }

    public static BigInteger isBetweenExclusive(@Nonnull BigInteger bigInteger, @Nonnull String string, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        if (ValueEnforcer.isEnabled()) {
            return ValueEnforcer.isBetweenExclusive(bigInteger, () -> string, bigInteger2, bigInteger3);
        }
        return bigInteger;
    }

    public static BigInteger isBetweenExclusive(@Nonnull BigInteger bigInteger, @Nonnull Supplier<? extends String> supplier, @Nonnull BigInteger bigInteger2, @Nonnull BigInteger bigInteger3) {
        ValueEnforcer.notNull(bigInteger, supplier);
        ValueEnforcer.notNull(bigInteger2, "LowerBoundInclusive");
        ValueEnforcer.notNull(bigInteger3, "UpperBoundInclusive");
        if (ValueEnforcer.isEnabled() && (bigInteger.compareTo(bigInteger2) <= 0 || bigInteger.compareTo(bigInteger3) >= 0)) {
            throw new IllegalArgumentException("The value of '" + supplier.get() + "' must be > " + String.valueOf(bigInteger2) + " and < " + String.valueOf(bigInteger3) + "! The current value is: " + String.valueOf(bigInteger));
        }
        return bigInteger;
    }

    private static void _isArrayOfsLen(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3) {
        ValueEnforcer.isGE0(n2, "Offset");
        ValueEnforcer.isGE0(n3, "Length");
        if (ValueEnforcer.isEnabled() && n2 + n3 > n) {
            throw new IllegalArgumentException("Offset (" + n2 + ") + length (" + n3 + ") exceeds array length (" + n + ")");
        }
    }

    public static void isArrayOfsLen(@Nonnull Object[] objectArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(objectArray, "Array");
        ValueEnforcer._isArrayOfsLen(objectArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull boolean[] blArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(blArray, "Array");
        ValueEnforcer._isArrayOfsLen(blArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(byArray, "Array");
        ValueEnforcer._isArrayOfsLen(byArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(cArray, "Array");
        ValueEnforcer._isArrayOfsLen(cArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull double[] dArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(dArray, "Array");
        ValueEnforcer._isArrayOfsLen(dArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull float[] fArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(fArray, "Array");
        ValueEnforcer._isArrayOfsLen(fArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(nArray, "Array");
        ValueEnforcer._isArrayOfsLen(nArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull long[] lArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(lArray, "Array");
        ValueEnforcer._isArrayOfsLen(lArray.length, n, n2);
    }

    public static void isArrayOfsLen(@Nonnull short[] sArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull(sArray, "Array");
        ValueEnforcer._isArrayOfsLen(sArray.length, n, n2);
    }
}

