/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.dimension;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.dimension.IHasDimensionDouble;
import com.helger.base.dimension.IHasDimensionFloat;
import com.helger.base.dimension.IHasDimensionInt;
import com.helger.base.dimension.IHasDimensionLong;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;

@Immutable
public class SizeDouble
implements IHasDimensionDouble {
    private final double m_dWidth;
    private final double m_dHeight;

    public SizeDouble(@Nonnull IHasDimensionInt iHasDimensionInt) {
        this(iHasDimensionInt.getWidth(), iHasDimensionInt.getHeight());
    }

    public SizeDouble(@Nonnull IHasDimensionLong iHasDimensionLong) {
        this(iHasDimensionLong.getWidth(), iHasDimensionLong.getHeight());
    }

    public SizeDouble(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        this(iHasDimensionFloat.getWidth(), iHasDimensionFloat.getHeight());
    }

    public SizeDouble(@Nonnull IHasDimensionDouble iHasDimensionDouble) {
        this(iHasDimensionDouble.getWidth(), iHasDimensionDouble.getHeight());
    }

    public SizeDouble(@Nonnegative double d, @Nonnegative double d2) {
        this.m_dWidth = ValueEnforcer.isGE0(d, "Width");
        this.m_dHeight = ValueEnforcer.isGE0(d2, "Height");
    }

    @Override
    @Nonnegative
    public double getWidth() {
        return this.m_dWidth;
    }

    @Override
    @Nonnegative
    public double getHeight() {
        return this.m_dHeight;
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getBestMatchingSize(@Nonnegative double d, @Nonnegative double d2) {
        ValueEnforcer.isGT0(d, "MaxWidth");
        ValueEnforcer.isGT0(d2, "MaxHeight");
        double d3 = this.m_dWidth / d;
        double d4 = this.m_dHeight / d2;
        if (d3 > d4) {
            if (this.m_dWidth > d) {
                return new SizeDouble(d, this.m_dHeight / d3);
            }
        } else if (this.m_dHeight > d2) {
            return new SizeDouble(this.m_dWidth / d4, d2);
        }
        return this;
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getScaledToWidth(@Nonnegative double d) {
        ValueEnforcer.isGT0(d, "NewWidth");
        if (this.m_dWidth == d) {
            return this;
        }
        double d2 = d / this.m_dWidth;
        return new SizeDouble(d, this.m_dHeight * d2);
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getScaledToHeight(@Nonnegative double d) {
        ValueEnforcer.isGT0(d, "NewHeight");
        if (this.m_dHeight == d) {
            return this;
        }
        double d2 = d / this.m_dHeight;
        return new SizeDouble(this.m_dWidth * d2, d);
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getAdded(@Nonnull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToAdd");
        return new SizeDouble(this.m_dWidth + (double)iHasDimensionInt.getWidth(), this.m_dHeight + (double)iHasDimensionInt.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getAdded(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToAdd");
        return new SizeDouble(this.m_dWidth + (double)iHasDimensionFloat.getWidth(), this.m_dHeight + (double)iHasDimensionFloat.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getAdded(@Nonnull IHasDimensionDouble iHasDimensionDouble) {
        ValueEnforcer.notNull(iHasDimensionDouble, "ToAdd");
        return new SizeDouble(this.m_dWidth + iHasDimensionDouble.getWidth(), this.m_dHeight + iHasDimensionDouble.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getSubtracted(@Nonnull IHasDimensionInt iHasDimensionInt) {
        ValueEnforcer.notNull(iHasDimensionInt, "ToSubtract");
        return new SizeDouble(this.m_dWidth - (double)iHasDimensionInt.getWidth(), this.m_dHeight - (double)iHasDimensionInt.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getSubtracted(@Nonnull IHasDimensionFloat iHasDimensionFloat) {
        ValueEnforcer.notNull(iHasDimensionFloat, "ToSubtract");
        return new SizeDouble(this.m_dWidth - (double)iHasDimensionFloat.getWidth(), this.m_dHeight - (double)iHasDimensionFloat.getHeight());
    }

    @Nonnull
    @CheckReturnValue
    public SizeDouble getSubtracted(@Nonnull IHasDimensionDouble iHasDimensionDouble) {
        ValueEnforcer.notNull(iHasDimensionDouble, "ToSubtract");
        return new SizeDouble(this.m_dWidth - iHasDimensionDouble.getWidth(), this.m_dHeight - iHasDimensionDouble.getHeight());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SizeDouble sizeDouble = (SizeDouble)object;
        return EqualsHelper.equals(this.m_dWidth, sizeDouble.m_dWidth) && EqualsHelper.equals(this.m_dHeight, sizeDouble.m_dHeight);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_dWidth).append(this.m_dHeight).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("width", this.m_dWidth).append("height", this.m_dHeight).getToString();
    }
}

