/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.codec.impl;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillNotClose;
import com.helger.base.codec.DecodeException;
import com.helger.base.codec.IByteArrayStreamDecoder;
import com.helger.base.string.StringHex;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;

public class ASCIIHexCodec
implements IByteArrayStreamDecoder {
    @Override
    public void decode(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull @WillNotClose OutputStream outputStream) {
        if (byArray == null || n2 == 0) {
            return;
        }
        try {
            byte by;
            boolean bl = true;
            int n3 = 0;
            for (int i = 0; i < n2 && (by = byArray[n + i]) != 62; ++i) {
                if (Character.isWhitespace(by)) continue;
                byte by2 = (byte)StringHex.getHexValue((char)by);
                if (by2 == -1) {
                    throw new DecodeException("Failed to convert byte '" + by + "/" + (char)by + "' to hex value in ASCIIHexDecode");
                }
                if (bl) {
                    n3 = by2;
                } else {
                    outputStream.write((byte)(n3 << 4 | by2 & 0xFF));
                }
                bl = !bl;
            }
            if (!bl) {
                outputStream.write((byte)(n3 << 4));
            }
        }
        catch (IOException iOException) {
            throw new DecodeException("Failed to decode ASCII Hex", iOException);
        }
    }
}

