/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.callback;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.callback.ICallback;
import com.helger.base.callback.ICallbackList;
import com.helger.base.clone.ICloneable;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CallbackList<CALLBACKTYPE extends ICallback>
implements ICallbackList<CALLBACKTYPE>,
ICloneable<CallbackList<CALLBACKTYPE>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallbackList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final Set<CALLBACKTYPE> m_aCallbacks = new LinkedHashSet<CALLBACKTYPE>();

    public CallbackList() {
    }

    public CallbackList(@Nullable CallbackList<CALLBACKTYPE> callbackList) {
        if (callbackList != null) {
            this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
        }
    }

    @Nonnull
    public EChange set(@Nonnull CallbackList<CALLBACKTYPE> callbackList) {
        ValueEnforcer.notNull(callbackList, "rhs");
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.valueOf(!this.m_aCallbacks.isEmpty() || callbackList.isNotEmpty());
            this.m_aCallbacks.clear();
            this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
            return eChange;
        });
    }

    @Nonnull
    public EChange set(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.valueOf(!this.m_aCallbacks.isEmpty());
            this.m_aCallbacks.clear();
            this.m_aCallbacks.add(CALLBACKTYPE);
            return eChange;
        });
    }

    @Nonnull
    public EChange add(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        return this.m_aRWLock.writeLockedGet(() -> EChange.valueOf(this.m_aCallbacks.add(CALLBACKTYPE)));
    }

    @Nonnull
    @SafeVarargs
    public final EChange addAll(CALLBACKTYPE ... CALLBACKTYPEArray) {
        ValueEnforcer.notNullNoNullValue(CALLBACKTYPEArray, "Callbacks");
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.UNCHANGED;
            for (ICallback iCallback : CALLBACKTYPEArray) {
                if (!this.m_aCallbacks.add(iCallback)) continue;
                eChange = EChange.CHANGED;
            }
            return eChange;
        });
    }

    @Nonnull
    public EChange removeObject(@Nullable CALLBACKTYPE CALLBACKTYPE) {
        if (CALLBACKTYPE == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLockedGet(() -> EChange.valueOf(this.m_aCallbacks.remove(CALLBACKTYPE)));
    }

    @Nonnull
    public EChange removeAll() {
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.valueOf(!this.m_aCallbacks.isEmpty());
            this.m_aCallbacks.clear();
            return eChange;
        });
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CALLBACKTYPE> getAllCallbacks() {
        this.m_aRWLock.readLock().lock();
        try {
            ArrayList<CALLBACKTYPE> arrayList = new ArrayList<CALLBACKTYPE>(this.m_aCallbacks);
            return arrayList;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nullable
    public CALLBACKTYPE getCallbackAtIndex(@Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Index");
        return (CALLBACKTYPE)this.m_aRWLock.readLockedGet(() -> {
            int n2 = 0;
            for (ICallback iCallback : this.m_aCallbacks) {
                if (n2 == n) {
                    return iCallback;
                }
                ++n2;
            }
            return null;
        });
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(this.m_aCallbacks::size);
    }

    @Override
    public boolean isEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aCallbacks.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public CallbackList<CALLBACKTYPE> getClone() {
        return this.m_aRWLock.readLockedGet(() -> new CallbackList<CALLBACKTYPE>(this));
    }

    @Override
    @Nonnull
    public Iterator<CALLBACKTYPE> iterator() {
        return this.m_aRWLock.readLockedGet(this.m_aCallbacks::iterator);
    }

    @Override
    public void forEach(@Nonnull Consumer<? super CALLBACKTYPE> consumer) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                consumer.accept(iCallback);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke callback " + String.valueOf(iCallback), (Throwable)exception);
            }
        }
    }

    @Nonnull
    public EContinue forEachBreakable(@Nonnull Function<? super CALLBACKTYPE, EContinue> function) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                if (!function.apply(iCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
            catch (Exception exception) {
                LOGGER.error("Failed to invoke callback " + String.valueOf(iCallback), (Throwable)exception);
            }
        }
        return EContinue.CONTINUE;
    }

    public String toString() {
        return new ToStringGenerator(this).append("callbacks", this.m_aCallbacks).getToString();
    }
}

