/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.pool;

import com.helger.base.state.ESuccess;
import jakarta.annotation.Nonnull;
import java.util.function.Supplier;

public interface IObjectPoolFactory<DATATYPE> {
    @Nonnull
    public DATATYPE create();

    @Nonnull
    public ESuccess activate(@Nonnull DATATYPE var1);

    public void passivate(@Nonnull DATATYPE var1);

    @Nonnull
    public static <T> IObjectPoolFactory<T> wrap(final @Nonnull Supplier<? extends T> supplier) {
        return new IObjectPoolFactory<T>(){

            @Override
            @Nonnull
            public T create() {
                return supplier.get();
            }

            @Override
            @Nonnull
            public ESuccess activate(@Nonnull T t) {
                return ESuccess.SUCCESS;
            }

            @Override
            public void passivate(@Nonnull T t) {
            }
        };
    }
}

