/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.id.factory;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.id.factory.ILongIDFactory;
import com.helger.base.tostring.ToStringGenerator;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafe
public final class MemoryStaticLongIDFactory
implements ILongIDFactory {
    public static final long INITIAL_ID = 10000L;
    private static final AtomicLong ID = new AtomicLong(10000L);

    @Override
    @Nonnegative
    public long getNewID() {
        return MemoryStaticLongIDFactory.getNewStaticID();
    }

    @Nonnegative
    public static long getNewStaticID() {
        return ID.getAndIncrement();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && this.getClass().equals(object.getClass());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

