/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.system;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.log.IHasConditionalLogger;
import com.helger.base.rt.NonBlockingProperties;
import com.helger.base.state.EChange;
import com.helger.base.string.StringParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SystemProperties
implements IHasConditionalLogger {
    public static final double JAVA_CLASS_VERSION = StringParser.parseDouble(SystemProperties.getJavaClassVersion(), Double.NaN);
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemProperties.class);
    private static final ConditionalLogger CONDLOG = new ConditionalLogger(LOGGER);
    private static final Set<String> WARNED_PROP_NAMES = new CopyOnWriteArraySet<String>();
    private static final SystemProperties INSTANCE = new SystemProperties();

    private SystemProperties() {
    }

    public static boolean isSilentMode() {
        return CONDLOG.isDisabled();
    }

    public static boolean setSilentMode(boolean bl) {
        return !CONDLOG.setEnabled(!bl);
    }

    @Nullable
    public static String getPropertyValueOrNull(@Nullable String string) {
        return string == null ? null : System.getProperty(string);
    }

    @Nullable
    public static String getPropertyValue(@Nullable String string) {
        String string2 = null;
        if (string != null && (string2 = SystemProperties.getPropertyValueOrNull(string)) == null && WARNED_PROP_NAMES.add(string)) {
            CONDLOG.warn(() -> "System property '" + string + "' cannot be read because it is not set");
        }
        return string2;
    }

    public static void clearWarnedPropertyNames() {
        WARNED_PROP_NAMES.clear();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllWarnedPropertyNames() {
        return new HashSet<String>(WARNED_PROP_NAMES);
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, boolean bl) {
        return SystemProperties.setPropertyValue(string, Boolean.toString(bl));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, int n) {
        return SystemProperties.setPropertyValue(string, Integer.toString(n));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, long l) {
        return SystemProperties.setPropertyValue(string, Long.toString(l));
    }

    @Nonnull
    public static EChange setPropertyValue(@Nonnull String string, @Nullable String string2) {
        boolean bl;
        if (string2 == null) {
            bl = SystemProperties.removePropertyValue(string) != null;
        } else {
            String string3 = System.setProperty(string, string2);
            boolean bl2 = bl = string3 != null && !string2.equals(string3);
            if (bl) {
                CONDLOG.info(() -> "Set system property '" + string + "' to '" + string2 + "'");
            }
        }
        return EChange.valueOf(bl);
    }

    @Nullable
    public static String removePropertyValue(@Nonnull String string) {
        String string2 = System.clearProperty(string);
        if (string2 != null) {
            CONDLOG.info(() -> "Removed system property '" + string + "' with value '" + string2 + "'");
        } else {
            CONDLOG.warn(() -> "Remove system property '" + string + "' failed");
        }
        return string2;
    }

    @Nullable
    public static String getJavaVersion() {
        return SystemProperties.getPropertyValue("java.version");
    }

    @Nullable
    public static String getJavaVendor() {
        return SystemProperties.getPropertyValue("java.vendor");
    }

    @Nullable
    public static String getJavaVendorURL() {
        return SystemProperties.getPropertyValue("java.vendor.url");
    }

    @Nullable
    public static String getJavaHome() {
        return SystemProperties.getPropertyValue("java.home");
    }

    @Nullable
    public static String getJavaClassVersion() {
        return SystemProperties.getPropertyValue("java.class.version");
    }

    @Nullable
    public static String getJavaClassPath() {
        return SystemProperties.getPropertyValue("java.class.path");
    }

    @Nullable
    public static String getJavaLibraryPath() {
        return SystemProperties.getPropertyValue("java.library.path");
    }

    @Nullable
    public static String getOsName() {
        return SystemProperties.getPropertyValue("os.name");
    }

    @Nullable
    public static String getOsArch() {
        return SystemProperties.getPropertyValue("os.arch");
    }

    @Nullable
    public static String getOsVersion() {
        return SystemProperties.getPropertyValue("os.version");
    }

    @Nullable
    public static String getFileSeparator() {
        return SystemProperties.getPropertyValue("file.separator");
    }

    @Nullable
    public static String getPathSeparator() {
        return SystemProperties.getPropertyValue("path.separator");
    }

    @Nullable
    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    @Nullable
    public static String getUserName() {
        return SystemProperties.getPropertyValue("user.name");
    }

    @Nullable
    public static String getUserHome() {
        return SystemProperties.getPropertyValue("user.home");
    }

    @Nullable
    public static String getUserDir() {
        return SystemProperties.getPropertyValue("user.dir");
    }

    @Nullable
    public static String getJavaVmName() {
        return SystemProperties.getPropertyValue("java.vm.name");
    }

    @Nullable
    public static String getJavaVmSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.vm.specification.version");
    }

    @Nullable
    public static String getJavaVmSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.vm.specification.vendor");
    }

    @Nullable
    public static String getJavaVmSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.vm.specification.url");
    }

    @Nullable
    public static String getJavaVmVersion() {
        return SystemProperties.getPropertyValue("java.vm.version");
    }

    @Nullable
    public static String getJavaVmVendor() {
        return SystemProperties.getPropertyValue("java.vm.vendor");
    }

    @Nullable
    public static String getJavaVmUrl() {
        return SystemProperties.getPropertyValue("java.vm.url");
    }

    @Nullable
    public static String getJavaSpecificationVersion() {
        return SystemProperties.getPropertyValue("java.specification.version");
    }

    @Nullable
    public static String getJavaSpecificationVendor() {
        return SystemProperties.getPropertyValue("java.specification.vendor");
    }

    @Nullable
    public static String getJavaSpecificationUrl() {
        return SystemProperties.getPropertyValue("java.specification.url");
    }

    @Nullable
    @DevelopersNote(value="This property is not part of the language but part of the Sun SDK")
    public static String getTmpDir() {
        return SystemProperties.getPropertyValue("java.io.tmpdir");
    }

    @Nullable
    public static String getJavaRuntimeVersion() {
        return SystemProperties.getPropertyValue("java.runtime.version");
    }

    @Nullable
    public static String getJavaRuntimeName() {
        return SystemProperties.getPropertyValue("java.runtime.name");
    }

    @Nonnull
    @ReturnsMutableCopy
    public static NonBlockingProperties getAllProperties() {
        Properties properties = System.getProperties();
        if (properties == null) {
            return new NonBlockingProperties();
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            nonBlockingProperties.put(Objects.toString(entry.getKey()), Objects.toString(entry.getValue()));
        }
        return nonBlockingProperties;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllPropertyNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Properties properties = System.getProperties();
        if (properties != null) {
            for (Object object : properties.keySet()) {
                hashSet.add(Objects.toString(object));
            }
        }
        return hashSet;
    }

    public static boolean containsPropertyName(String string) {
        return SystemProperties.getAllProperties().containsKey(string);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static String[] getAllJavaNetSystemProperties() {
        return new String[]{"javax.net.debug", "java.security.debug", "java.net.useSystemProxies", "http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
    }
}

