/*
 * Decompiled with CFR 0.152.
 */
package com.helger.base.io.streamprovider;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.io.iface.IHasReader;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;

public class StringReaderProvider
implements IHasReader {
    private final String m_sData;

    public StringReaderProvider(@Nonnull char[] cArray) {
        this(new String(cArray));
    }

    public StringReaderProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this(new String(cArray, n, n2));
    }

    public StringReaderProvider(@Nonnull CharSequence charSequence) {
        this(charSequence.toString());
    }

    public StringReaderProvider(@Nonnull String string) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringReaderProvider stringReaderProvider = (StringReaderProvider)object;
        return this.m_sData.equals(stringReaderProvider.m_sData);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).getToString();
    }
}

