/*
 * Decompiled with CFR 0.152.
 */
package com.hbb20;

import android.content.Context;
import android.telephony.PhoneNumberUtils;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.TextWatcher;
import io.michaelrocks.libphonenumber.android.AsYouTypeFormatter;
import io.michaelrocks.libphonenumber.android.PhoneNumberUtil;

public class InternationalPhoneTextWatcher
implements TextWatcher {
    private static final String TAG = "Int'l Phone TextWatcher";
    PhoneNumberUtil phoneNumberUtil;
    private boolean mSelfChange = false;
    private boolean mStopFormatting;
    private AsYouTypeFormatter mFormatter;
    private String countryNameCode;
    Editable lastFormatted = null;
    private int countryPhoneCode;
    private boolean needUpdateForCountryChange = false;
    private boolean internationalOnly;

    public InternationalPhoneTextWatcher(Context context, String countryNameCode, int countryPhoneCode) {
        this(context, countryNameCode, countryPhoneCode, true);
    }

    public InternationalPhoneTextWatcher(Context context, String countryNameCode, int countryPhoneCode, boolean internationalOnly) {
        if (countryNameCode == null || countryNameCode.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.phoneNumberUtil = PhoneNumberUtil.createInstance((Context)context);
        this.updateCountry(countryNameCode, countryPhoneCode);
        this.internationalOnly = internationalOnly;
    }

    public void updateCountry(String countryNameCode, int countryPhoneCode) {
        this.countryNameCode = countryNameCode;
        this.countryPhoneCode = countryPhoneCode;
        this.mFormatter = this.phoneNumberUtil.getAsYouTypeFormatter(countryNameCode);
        this.mFormatter.clear();
        if (this.lastFormatted != null) {
            this.needUpdateForCountryChange = true;
            String onlyDigits = PhoneNumberUtil.normalizeDigitsOnly((CharSequence)this.lastFormatted);
            this.lastFormatted.replace(0, this.lastFormatted.length(), (CharSequence)onlyDigits, 0, onlyDigits.length());
            this.needUpdateForCountryChange = false;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count) && !this.needUpdateForCountryChange) {
            this.stopFormatting();
        }
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.mSelfChange || this.mStopFormatting) {
            return;
        }
        if (count > 0 && this.hasSeparator(s, start, count)) {
            this.stopFormatting();
        }
    }

    public synchronized void afterTextChanged(Editable s) {
        if (this.mStopFormatting) {
            this.mStopFormatting = s.length() != 0;
            return;
        }
        if (this.mSelfChange) {
            return;
        }
        int selectionEnd = Selection.getSelectionEnd((CharSequence)s);
        boolean isCursorAtEnd = selectionEnd == s.length();
        String formatted = this.reformat((CharSequence)s);
        int finalCursorPosition = 0;
        if (formatted.equals(s.toString())) {
            finalCursorPosition = selectionEnd;
        } else if (isCursorAtEnd) {
            finalCursorPosition = formatted.length();
        } else {
            int i;
            int digitsBeforeCursor = 0;
            for (i = 0; i < s.length() && i < selectionEnd; ++i) {
                if (!PhoneNumberUtils.isNonSeparator((char)s.charAt(i))) continue;
                ++digitsBeforeCursor;
            }
            int digitPassed = 0;
            for (i = 0; i < formatted.length(); ++i) {
                if (digitPassed == digitsBeforeCursor) {
                    finalCursorPosition = i;
                    break;
                }
                if (!PhoneNumberUtils.isNonSeparator((char)formatted.charAt(i))) continue;
                ++digitPassed;
            }
        }
        if (!isCursorAtEnd) {
            while (0 < finalCursorPosition - 1 && !PhoneNumberUtils.isNonSeparator((char)formatted.charAt(finalCursorPosition - 1))) {
                --finalCursorPosition;
            }
        }
        try {
            if (formatted != null) {
                this.mSelfChange = true;
                s.replace(0, s.length(), (CharSequence)formatted, 0, formatted.length());
                this.mSelfChange = false;
                this.lastFormatted = s;
                Selection.setSelection((Spannable)s, (int)finalCursorPosition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String reformat(CharSequence s) {
        String internationalFormatted = "";
        this.mFormatter.clear();
        char lastNonSeparator = '\u0000';
        String countryCallingCode = "+" + this.countryPhoneCode;
        if (this.internationalOnly || s.length() > 0 && s.charAt(0) != '0') {
            s = countryCallingCode + s;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator((char)c)) continue;
            if (lastNonSeparator != '\u0000') {
                internationalFormatted = this.mFormatter.inputDigit(lastNonSeparator);
            }
            lastNonSeparator = c;
        }
        if (lastNonSeparator != '\u0000') {
            internationalFormatted = this.mFormatter.inputDigit(lastNonSeparator);
        }
        internationalFormatted = internationalFormatted.trim();
        if (this.internationalOnly || s.length() == 0 || s.charAt(0) != '0') {
            internationalFormatted = internationalFormatted.length() > countryCallingCode.length() ? (internationalFormatted.charAt(countryCallingCode.length()) == ' ' ? internationalFormatted.substring(countryCallingCode.length() + 1) : internationalFormatted.substring(countryCallingCode.length())) : "";
        }
        return TextUtils.isEmpty((CharSequence)internationalFormatted) ? "" : internationalFormatted;
    }

    private void stopFormatting() {
        this.mStopFormatting = true;
        this.mFormatter.clear();
    }

    private boolean hasSeparator(CharSequence s, int start, int count) {
        for (int i = start; i < start + count; ++i) {
            char c = s.charAt(i);
            if (PhoneNumberUtils.isNonSeparator((char)c)) continue;
            return true;
        }
        return false;
    }
}

