/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.JetConventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.ProjectLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ProjectPhysicalRel;
import java.util.Collection;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;

final class ProjectPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new ProjectPhysicalRule();

    private ProjectPhysicalRule() {
        super(ProjectPhysicalRule.operand(ProjectLogicalRel.class, (RelTrait)JetConventions.LOGICAL, (RelOptRuleOperandChildren)ProjectPhysicalRule.some((RelOptRuleOperand)ProjectPhysicalRule.operand(RelNode.class, (RelOptRuleOperandChildren)ProjectPhysicalRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])), ProjectPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        ProjectLogicalRel logicalProject = (ProjectLogicalRel)call.rel(0);
        RelNode input = logicalProject.getInput();
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            ProjectPhysicalRel rel = new ProjectPhysicalRel(logicalProject.getCluster(), transformedInput.getTraitSet(), transformedInput, logicalProject.getProjects(), logicalProject.getRowType());
            call.transformTo((RelNode)rel);
        }
    }
}

