/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class HazelcastJsonUpsertTarget
implements UpsertTarget {
    private JsonObject json;

    HazelcastJsonUpsertTarget() {
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        switch (type.getTypeFamily()) {
            case BOOLEAN: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, ((Boolean)value).booleanValue());
                    }
                };
            }
            case TINYINT: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, (int)((Byte)value).byteValue());
                    }
                };
            }
            case SMALLINT: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, (int)((Short)value).shortValue());
                    }
                };
            }
            case INTEGER: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, ((Integer)value).intValue());
                    }
                };
            }
            case BIGINT: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, ((Long)value).longValue());
                    }
                };
            }
            case REAL: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, ((Float)value).floatValue());
                    }
                };
            }
            case DOUBLE: {
                return value -> {
                    if (value == null) {
                        this.json.add(path, (String)null);
                    } else {
                        this.json.add(path, ((Double)value).doubleValue());
                    }
                };
            }
            case DECIMAL: 
            case TIME: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case VARCHAR: {
                return value -> this.json.add(path, (String)QueryDataType.VARCHAR.convert(value));
            }
            case OBJECT: {
                return this.createObjectInjector(path);
            }
        }
        throw QueryException.error((String)("Unsupported type: " + type));
    }

    private UpsertInjector createObjectInjector(String path) {
        return value -> {
            if (value == null) {
                this.json.add(path, (String)null);
            } else if (value instanceof JsonValue) {
                this.json.add(path, (JsonValue)value);
            } else if (value instanceof Boolean) {
                this.json.add(path, ((Boolean)value).booleanValue());
            } else if (value instanceof Byte) {
                this.json.add(path, (int)((Byte)value).byteValue());
            } else if (value instanceof Short) {
                this.json.add(path, (int)((Short)value).shortValue());
            } else if (value instanceof Integer) {
                this.json.add(path, ((Integer)value).intValue());
            } else if (value instanceof Long) {
                this.json.add(path, ((Long)value).longValue());
            } else if (value instanceof Float) {
                this.json.add(path, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                this.json.add(path, ((Double)value).doubleValue());
            } else {
                this.json.add(path, (String)QueryDataType.VARCHAR.convert(value));
            }
        };
    }

    @Override
    public void init() {
        this.json = Json.object();
    }

    @Override
    public Object conclude() {
        JsonObject json = this.json;
        this.json = null;
        return new HazelcastJsonValue(json.toString());
    }
}

