/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;

public class FullScanPhysicalRel
extends TableScan
implements PhysicalRel {
    FullScanPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, table);
    }

    public Expression<Boolean> filter() {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        RexNode filter = ((HazelcastTable)this.getTable().unwrap(HazelcastTable.class)).getFilter();
        return this.filter((PlanNodeFieldTypeProvider)schema, filter);
    }

    public List<Expression<?>> projection() {
        PlanNodeSchema schema = OptUtils.schema(this.getTable());
        HazelcastTable table = (HazelcastTable)this.getTable().unwrap(HazelcastTable.class);
        List projects = table.getProjects();
        ArrayList<RexInputRef> projection = new ArrayList<RexInputRef>(projects.size());
        for (Integer index : projects) {
            TableField field = table.getTarget().getField(index.intValue());
            RelDataType relDataType = OptUtils.convert(field, this.getCluster().getTypeFactory());
            projection.add(new RexInputRef(index.intValue(), relDataType));
        }
        return this.project((PlanNodeFieldTypeProvider)schema, projection);
    }

    @Override
    public PlanNodeSchema schema() {
        List fieldTypes = Util.toList(this.projection(), Expression::getType);
        return new PlanNodeSchema(fieldTypes);
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onFullScan(this);
    }

    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new FullScanPhysicalRel(this.getCluster(), traitSet, this.getTable());
    }
}

