/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.pipeline.file.FileSourceBuilder;
import com.hazelcast.jet.pipeline.file.FileSources;
import com.hazelcast.jet.pipeline.file.impl.FileProcessorMetaSupplier;
import com.hazelcast.jet.pipeline.file.impl.FileTraverser;
import com.hazelcast.jet.sql.impl.connector.file.FileTableField;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

abstract class MetadataResolver<T> {
    MetadataResolver() {
    }

    String supportedFormat() {
        return this.sampleFormat().format();
    }

    List<MappingField> resolveAndValidateFields(List<MappingField> userFields, Map<String, ?> options) {
        return !userFields.isEmpty() ? this.validateFields(userFields) : this.resolveFieldsFromSample((T)options);
    }

    private List<MappingField> validateFields(List<MappingField> userFields) {
        for (MappingField userField : userFields) {
            String externalName = userField.externalName();
            if (externalName == null || externalName.indexOf(46) < 0) continue;
            throw QueryException.error((String)("Invalid field external name - '" + externalName + "'. Nested fields are not supported."));
        }
        return userFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MappingField> resolveFieldsFromSample(Map<String, ?> options) {
        FileProcessorMetaSupplier fileProcessorMetaSupplier = (FileProcessorMetaSupplier)this.toProcessorMetaSupplierProvider(options, this.sampleFormat()).get();
        try (FileTraverser traverser = fileProcessorMetaSupplier.traverser();){
            Object sample = traverser.next();
            if (sample == null) {
                throw QueryException.error((String)"No sample found to resolve the columns");
            }
            List<MappingField> list = this.resolveFieldsFromSample(sample);
            return list;
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    protected abstract Metadata resolveMetadata(List<MappingField> var1, Map<String, ?> var2);

    protected List<TableField> toFields(List<MappingField> resolvedFields) {
        return Util.toList(resolvedFields, field -> new FileTableField(field.name(), field.type(), field.externalName() == null ? field.name() : field.externalName()));
    }

    protected Supplier<ProcessorMetaSupplier> toProcessorMetaSupplierProvider(Map<String, ?> options, FileFormat<?> format) {
        return () -> {
            String ignoreFileNotFound;
            String sharedFileSystem;
            FileSourceBuilder builder = FileSources.files((String)((String)options.get("path"))).format(format);
            String glob = (String)options.get("glob");
            if (glob != null) {
                builder.glob(glob);
            }
            if ((sharedFileSystem = (String)options.get("sharedFileSystem")) != null) {
                builder.sharedFileSystem(Boolean.parseBoolean(sharedFileSystem));
            }
            if ((ignoreFileNotFound = (String)options.get("ignoreFileNotFound")) != null) {
                builder.ignoreFileNotFound(Boolean.parseBoolean(ignoreFileNotFound));
            }
            for (Map.Entry entry : options.entrySet()) {
                String key = (String)entry.getKey();
                if ("path".equals(key) || "glob".equals(key) || "sharedFileSystem".equals(key) || "ignoreFileNotFound".equals(key)) continue;
                Object value = entry.getValue();
                if (value instanceof String) {
                    builder.option(key, (String)value);
                    continue;
                }
                if (value instanceof Map) {
                    for (Map.Entry option : ((Map)value).entrySet()) {
                        builder.option((String)option.getKey(), (String)option.getValue());
                    }
                    continue;
                }
                throw new IllegalArgumentException("Unexpected option type: " + value.getClass());
            }
            return builder.buildMetaSupplier();
        };
    }

    protected abstract FileFormat<?> sampleFormat();

    protected abstract List<MappingField> resolveFieldsFromSample(T var1);
}

