/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.schema.JetTableFunction;
import com.hazelcast.sql.impl.QueryException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.util.NlsString;

public final class JetSqlUserDefinedTableFunction
extends SqlUserDefinedTableFunction {
    private final JetTableFunction function;

    public JetSqlUserDefinedTableFunction(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> parameterTypes, JetTableFunction function) {
        super(opName, returnTypeInference, operandTypeInference, operandTypeChecker, parameterTypes, (TableFunction)function);
        for (RelDataType parameterType : parameterTypes) {
            SqlTypeName type = parameterType.getSqlTypeName();
            Preconditions.checkTrue((type == SqlTypeName.INTEGER || type == SqlTypeName.VARCHAR || type == SqlTypeName.MAP ? 1 : 0) != 0, (String)("Unsupported type: " + type));
        }
        this.function = function;
    }

    public boolean isStreaming() {
        return this.function.isStream();
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<SqlNode> operands) {
        List<Object> arguments = JetSqlUserDefinedTableFunction.toArguments(typeFactory, this.getNameAsId(), this.getFunction().getParameters(), operands);
        return this.getFunction().getRowType(typeFactory, arguments);
    }

    private static List<Object> toArguments(RelDataTypeFactory typeFactory, SqlIdentifier name, List<FunctionParameter> parameters, List<SqlNode> operands) {
        assert (parameters.size() == operands.size());
        ArrayList<Object> arguments = new ArrayList<Object>(parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            SqlNode operand = operands.get(i);
            FunctionParameter parameter = parameters.get(i);
            Object value = JetSqlUserDefinedTableFunction.extractValue(typeFactory, name, parameter, operand);
            arguments.add(value);
        }
        return arguments;
    }

    private static Object extractValue(RelDataTypeFactory typeFactory, SqlIdentifier functionName, FunctionParameter parameter, SqlNode node) {
        if (node.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        if (SqlUtil.isNullLiteral((SqlNode)node, (boolean)true)) {
            return null;
        }
        SqlTypeName parameterType = parameter.getType(typeFactory).getSqlTypeName();
        if (SqlUtil.isLiteral((SqlNode)node) && parameterType == SqlTypeName.INTEGER) {
            Integer value = JetSqlUserDefinedTableFunction.extractIntegerValue((SqlLiteral)node);
            if (value != null) {
                return value;
            }
        } else if (SqlUtil.isLiteral((SqlNode)node) && parameterType == SqlTypeName.VARCHAR) {
            String value = JetSqlUserDefinedTableFunction.extractStringValue((SqlLiteral)node);
            if (value != null) {
                return value;
            }
        } else if (node.getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR && parameterType == SqlTypeName.MAP) {
            return JetSqlUserDefinedTableFunction.extractMapValue(functionName, parameter, (SqlCall)node);
        }
        throw QueryException.error((String)("Invalid argument of a call to function " + functionName + " - #" + parameter.getOrdinal() + " (" + parameter.getName() + "). Expected: " + parameterType + ", actual: " + (SqlUtil.isLiteral((SqlNode)node) ? ((SqlLiteral)node).getTypeName() : node.getKind())));
    }

    private static Integer extractIntegerValue(SqlLiteral literal) {
        Object value = literal.getValue();
        return value instanceof BigDecimal ? Integer.valueOf(((BigDecimal)value).intValue()) : null;
    }

    private static String extractStringValue(SqlLiteral literal) {
        Object value = literal.getValue();
        return value instanceof NlsString ? ((NlsString)value).getValue() : null;
    }

    private static Map<String, String> extractMapValue(SqlIdentifier functionName, FunctionParameter parameter, SqlCall call) {
        List operands = call.getOperandList();
        HashMap<String, String> entries = new HashMap<String, String>();
        for (int i = 0; i < operands.size(); i += 2) {
            String value;
            String key = JetSqlUserDefinedTableFunction.extractMapLiteralValue(functionName, parameter, (SqlNode)operands.get(i));
            if (entries.putIfAbsent(key, value = JetSqlUserDefinedTableFunction.extractMapLiteralValue(functionName, parameter, (SqlNode)operands.get(i + 1))) == null) continue;
            throw QueryException.error((String)("Duplicate entry in the MAP constructor in the call to function " + functionName + " - argument #" + parameter.getOrdinal() + " (" + parameter.getName() + ")"));
        }
        return entries;
    }

    private static String extractMapLiteralValue(SqlIdentifier functionName, FunctionParameter parameter, SqlNode node) {
        SqlLiteral literal;
        Object value;
        if (SqlUtil.isLiteral((SqlNode)node) && (value = (literal = (SqlLiteral)node).getValue()) instanceof NlsString) {
            return ((NlsString)value).getValue();
        }
        throw QueryException.error((String)("All values in the MAP constructor of the call to function " + functionName + ", argument #" + parameter.getOrdinal() + " (" + parameter.getName() + ") must be VARCHAR literals. Actual argument is: " + (SqlUtil.isLiteral((SqlNode)node) ? ((SqlLiteral)node).getTypeName() : node.getKind())));
    }
}

