/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.ResettableSingletonTraverser;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.processor.TransformP;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public final class KvProcessors {
    private KvProcessors() {
    }

    public static ProcessorSupplier rowProjector(QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projection) {
        return new RowProjectorProcessorSupplier(KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projection));
    }

    public static ProcessorSupplier entryProjector(QueryPath[] paths, QueryDataType[] types, UpsertTargetDescriptor keyDescriptor, UpsertTargetDescriptor valueDescriptor) {
        return new EntryProjectorProcessorSupplier(KvProjector.supplier(paths, types, keyDescriptor, valueDescriptor));
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class EntryProjectorProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private KvProjector.Supplier projectorSupplier;
        private transient InternalSerializationService serializationService;

        private EntryProjectorProcessorSupplier() {
        }

        EntryProjectorProcessorSupplier(KvProjector.Supplier projectorSupplier) {
            this.projectorSupplier = projectorSupplier;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            ArrayList<TransformP> processors = new ArrayList<TransformP>(count);
            for (int i = 0; i < count; ++i) {
                ResettableSingletonTraverser traverser = new ResettableSingletonTraverser();
                KvProjector projector = this.projectorSupplier.get(this.serializationService);
                TransformP processor = new TransformP((FunctionEx & Serializable)row -> {
                    traverser.accept(projector.project((Object[])row));
                    return traverser;
                });
                processors.add(processor);
            }
            return processors;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.projectorSupplier);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.projectorSupplier = (KvProjector.Supplier)in.readObject();
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class RowProjectorProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private KvRowProjector.Supplier projectorSupplier;
        private transient InternalSerializationService serializationService;
        private transient Extractors extractors;

        private RowProjectorProcessorSupplier() {
        }

        RowProjectorProcessorSupplier(KvRowProjector.Supplier projectorSupplier) {
            this.projectorSupplier = projectorSupplier;
        }

        public void init(@Nonnull ProcessorSupplier.Context context) {
            this.serializationService = ((Contexts.ProcSupplierCtx)context).serializationService();
            this.extractors = Extractors.newBuilder((InternalSerializationService)this.serializationService).build();
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            ArrayList<TransformP> processors = new ArrayList<TransformP>(count);
            for (int i = 0; i < count; ++i) {
                ResettableSingletonTraverser traverser = new ResettableSingletonTraverser();
                KvRowProjector projector = this.projectorSupplier.get(this.serializationService, this.extractors);
                TransformP processor = new TransformP((FunctionEx & Serializable)entry -> {
                    traverser.accept((Object)projector.project((Map.Entry<Object, Object>)entry));
                    return traverser;
                });
                processors.add(processor);
            }
            return processors;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.projectorSupplier);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.projectorSupplier = (KvRowProjector.Supplier)in.readObject();
        }
    }
}

