/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.avro.Schema;

final class AvroResolver {
    private AvroResolver() {
    }

    static List<MappingField> resolveFields(Schema schema) {
        LinkedHashMap<String, MappingField> fields = new LinkedHashMap<String, MappingField>();
        for (Schema.Field avroField : schema.getFields()) {
            String name = avroField.name();
            QueryDataType type = AvroResolver.resolveType(avroField.schema().getType());
            MappingField field = new MappingField(name, type);
            fields.putIfAbsent(field.name(), field);
        }
        return new ArrayList<MappingField>(fields.values());
    }

    private static QueryDataType resolveType(Schema.Type type) {
        switch (type) {
            case BOOLEAN: {
                return QueryDataType.BOOLEAN;
            }
            case INT: {
                return QueryDataType.INT;
            }
            case LONG: {
                return QueryDataType.BIGINT;
            }
            case FLOAT: {
                return QueryDataType.REAL;
            }
            case DOUBLE: {
                return QueryDataType.DOUBLE;
            }
            case STRING: {
                return QueryDataType.VARCHAR;
            }
        }
        return QueryDataType.OBJECT;
    }
}

