/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ValueSqlAggregation
extends SqlAggregation {
    private QueryDataType operandType;
    private Object value;

    private ValueSqlAggregation() {
    }

    public ValueSqlAggregation(int index, QueryDataType operandType) {
        super(index, false, false);
        this.operandType = operandType;
    }

    @Override
    public QueryDataType resultType() {
        return this.operandType;
    }

    @Override
    protected void accumulate(Object value) {
        assert (this.value == null || this.value.equals(value));
        this.value = value;
    }

    @Override
    public void combine(SqlAggregation other0) {
        ValueSqlAggregation other = (ValueSqlAggregation)other0;
        Object value = other.value;
        assert (this.value == null || this.value.equals(value));
        this.value = value;
    }

    @Override
    public Object collect() {
        return this.value;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.operandType);
        out.writeObject(this.value);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.operandType = (QueryDataType)in.readObject();
        this.value = in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueSqlAggregation that = (ValueSqlAggregation)o;
        return Objects.equals(this.operandType, that.operandType) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.operandType, this.value);
    }
}

