/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sourcebuilder.support;

import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryAddedListener;
import com.hazelcast.map.listener.MapListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.UUID;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SystemMonitorGui {
    private static final int WINDOW_X = 100;
    private static final int WINDOW_Y = 100;
    private static final int WINDOW_WIDTH = 1000;
    private static final int WINDOW_HEIGHT = 650;
    private static final int SCALE_Y = 1024;
    private static final int TIME_RANGE = 30000;
    private static final int Y_RANGE_MIN = -200;
    private static final int Y_RANGE_UPPER_INITIAL = 200;
    private final IMap<Long, Double> hzMap;
    private UUID entryListenerId;

    public SystemMonitorGui(IMap<Long, Double> hzMap) {
        this.hzMap = hzMap;
        EventQueue.invokeLater(this::startGui);
    }

    private void startGui() {
        XYSeries series = new XYSeries((Comparable)((Object)"Rate"), false);
        XYPlot plot = this.createChartFrame(series);
        ValueAxis xAxis = plot.getDomainAxis();
        ValueAxis yAxis = plot.getRangeAxis();
        xAxis.setRange(0.0, 30000.0);
        yAxis.setRange(-200.0, 200.0);
        long initialTimestamp = System.currentTimeMillis();
        EntryAddedListener entryAddedListener = event -> {
            long x = (Long)event.getKey() - initialTimestamp;
            double y = (Double)event.getValue() / 1024.0;
            EventQueue.invokeLater(() -> {
                series.add((double)x, y);
                xAxis.setRange((double)Math.max(0L, x - 30000L), (double)Math.max(30000L, x));
                yAxis.setRange(-200.0, Math.max(series.getMaxY(), 200.0));
            });
            this.hzMap.remove(event.getKey());
        };
        this.entryListenerId = this.hzMap.addEntryListener((MapListener)entryAddedListener, true);
    }

    private XYPlot createChartFrame(XYSeries series) {
        XYSeriesCollection dataSet = new XYSeriesCollection();
        dataSet.addSeries(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Memory Allocation Rate", (String)"Time (ms)", (String)"Allocation Rate (MB/s)", (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.BLUE);
        JFrame frame = new JFrame();
        frame.setBackground(Color.WHITE);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Hazelcast Jet Source Builder Sample");
        frame.setBounds(100, 100, 1000, 650);
        frame.setLayout(new BorderLayout());
        frame.add((Component)new ChartPanel(chart));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SystemMonitorGui.this.hzMap.removeEntryListener(SystemMonitorGui.this.entryListenerId);
            }
        });
        frame.setVisible(true);
        return plot;
    }
}

