/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.sockets;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.util.function.Consumer;

class NettyServer {
    private final int port;
    private final Consumer<Channel> channelActiveHandler;
    private final Consumer<Object> messageConsumer;
    private EventLoopGroup parentGroup;
    private EventLoopGroup childGroup;
    private Channel channel;

    NettyServer(int port, Consumer<Channel> channelActiveHandler, Consumer<Object> messageConsumer) {
        this.port = port;
        this.channelActiveHandler = channelActiveHandler;
        this.messageConsumer = messageConsumer;
    }

    void start() throws Exception {
        this.parentGroup = new NioEventLoopGroup(1);
        this.childGroup = new NioEventLoopGroup();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(this.parentGroup, this.childGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                pipeline.addLast("lineFrame", (ChannelHandler)new LineBasedFrameDecoder(256));
                pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
                pipeline.addLast("handler", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        Channel channel = ctx.channel();
                        NettyServer.this.channelActiveHandler.accept(channel);
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        NettyServer.this.messageConsumer.accept(msg);
                    }
                });
            }
        });
        this.channel = bootstrap.bind(this.port).channel();
        System.out.println("NettyServer started");
    }

    void stop() throws Exception {
        this.channel.close().get();
        this.parentGroup.shutdownGracefully().get();
        this.childGroup.shutdownGracefully().get();
        System.out.println("NettyServer closed");
    }
}

