/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.rollingaggregation;

import com.hazelcast.map.IMap;
import com.hazelcast.map.listener.EntryUpdatedListener;
import com.hazelcast.map.listener.MapListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.UUID;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class TradingVolumeGui {
    private static final int WINDOW_X = 100;
    private static final int WINDOW_Y = 100;
    private static final int WINDOW_WIDTH = 1200;
    private static final int WINDOW_HEIGHT = 650;
    private static final int INITIAL_TOP_Y = 5000000;
    private final IMap<String, Long> hzMap;
    private UUID entryListenerId;

    public TradingVolumeGui(IMap<String, Long> hzMap) {
        this.hzMap = hzMap;
        EventQueue.invokeLater(this::startGui);
    }

    private void startGui() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        CategoryPlot chartFrame = this.createChartFrame((CategoryDataset)dataset);
        ValueAxis yAxis = chartFrame.getRangeAxis();
        long[] topY = new long[]{5000000L};
        EntryUpdatedListener entryUpdatedListener = event -> EventQueue.invokeLater(() -> {
            dataset.addValue((Number)event.getValue(), (Comparable)event.getKey(), (Comparable)((Object)""));
            topY[0] = Math.max(topY[0], 5000000L * (1L + (Long)event.getValue() / 5000000L));
            yAxis.setRange(0.0, (double)topY[0]);
        });
        this.entryListenerId = this.hzMap.addEntryListener((MapListener)entryUpdatedListener, true);
    }

    private CategoryPlot createChartFrame(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart((String)"Trading Volume", (String)"Stock", (String)"Volume, USD", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        plot.getRenderer().setSeriesPaint(0, (Paint)Color.BLUE);
        JFrame frame = new JFrame();
        frame.setBackground(Color.WHITE);
        frame.setDefaultCloseOperation(3);
        frame.setTitle("Hazelcast Jet Source Builder Sample");
        frame.setBounds(100, 100, 1200, 650);
        frame.setLayout(new BorderLayout());
        frame.add((Component)new ChartPanel(chart));
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TradingVolumeGui.this.hzMap.removeEntryListener(TradingVolumeGui.this.entryListenerId);
            }
        });
        return plot;
    }
}

