/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.patternmatching;

import com.hazelcast.core.IMap;
import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.examples.patternmatching.support.TransactionEvent;
import com.hazelcast.jet.examples.patternmatching.support.TransactionGenerator;
import com.hazelcast.jet.examples.patternmatching.support.TransactionStatusGui;
import com.hazelcast.jet.function.SupplierEx;
import com.hazelcast.jet.function.TriFunction;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.StreamSource;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class TransactionTracking {
    private static final int EVENTS_PER_SECOND = 20;
    private static final String STATUS_MAP_NAME = "transactionStatus";
    private static final int TRANSACTION_TIMEOUT_SECONDS = 2;

    private static Pipeline buildPipeline() {
        Pipeline p = Pipeline.create();
        StreamSource<TransactionEvent> source = TransactionGenerator.transactionEventSource(20);
        p.drawFrom(source).withTimestamps(TransactionEvent::timestamp, 0L).groupingKey(TransactionEvent::transactionId).mapStateful(TimeUnit.SECONDS.toMillis(2L), (SupplierEx & Serializable)() -> new TransactionEvent[2], (TriFunction & Serializable)(startEnd, transactionId, transactionEvent) -> {
            switch (transactionEvent.type()) {
                case START: {
                    startEnd[0] = transactionEvent;
                    break;
                }
                case END: {
                    startEnd[1] = transactionEvent;
                    break;
                }
                default: {
                    System.out.println("Wrong event in the stream: " + (Object)((Object)transactionEvent.type()));
                }
            }
            TransactionEvent startEvent = startEnd[0];
            TransactionEvent endEvent = startEnd[1];
            return startEvent != null && endEvent != null ? Util.entry((Object)transactionId, (Object)(endEvent.timestamp() - startEvent.timestamp())) : (startEvent != null ? Util.entry((Object)transactionId, (Object)-1L) : null);
        }, (TriFunction & Serializable)(startEnd, transactionId, wm) -> startEnd[0] != null && startEnd[1] == null ? Util.entry((Object)transactionId, (Object)-2L) : null).drainTo(Sinks.map((String)STATUS_MAP_NAME));
        return p;
    }

    public static void main(String[] args) {
        JetInstance jet = Jet.newJetInstance();
        try {
            new TransactionStatusGui((IMap<Long, Long>)jet.getMap(STATUS_MAP_NAME));
            jet.newJob(TransactionTracking.buildPipeline()).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }
}

