/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.examples.files;

import com.hazelcast.jet.Jet;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.aggregate.AggregateOperations;
import com.hazelcast.jet.function.Functions;
import com.hazelcast.jet.function.PredicateEx;
import com.hazelcast.jet.pipeline.Pipeline;
import com.hazelcast.jet.pipeline.Sinks;
import com.hazelcast.jet.pipeline.Sources;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessLogAnalyzer {
    private static Pipeline buildPipeline(String sourceDir, String targetDir) {
        Pipeline p = Pipeline.create();
        p.drawFrom(Sources.files((String)sourceDir)).map(LogLine::parse).filter((PredicateEx & Serializable)log -> log.getResponseCode() >= 200 && log.getResponseCode() < 400).flatMap(AccessLogAnalyzer::explodeSubPaths).groupingKey(Functions.wholeItem()).aggregate(AggregateOperations.counting()).drainTo(Sinks.files((String)targetDir));
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage:");
            System.err.println("  " + AccessLogAnalyzer.class.getSimpleName() + " <sourceDir> <targetDir>");
            System.exit(1);
        }
        String sourceDir = args[0];
        String targetDir = args[1];
        Pipeline p = AccessLogAnalyzer.buildPipeline(sourceDir, targetDir);
        JetInstance instance = Jet.newJetInstance();
        try {
            instance.newJob(p).join();
        }
        finally {
            Jet.shutdownAll();
        }
    }

    private static Traverser<String> explodeSubPaths(LogLine logLine) {
        int qmarkPos = logLine.getEndpoint().indexOf(63);
        final String endpoint = qmarkPos < 0 ? logLine.getEndpoint() : logLine.getEndpoint().substring(0, qmarkPos);
        return new Traverser<String>(){
            private int indexOfSlash;

            public String next() {
                if (this.indexOfSlash < 0) {
                    return null;
                }
                int nextIndexOfSlash = endpoint.indexOf(47, this.indexOfSlash + 1);
                try {
                    String string = nextIndexOfSlash < 0 ? endpoint : endpoint.substring(0, nextIndexOfSlash + 1);
                    return string;
                }
                finally {
                    this.indexOfSlash = nextIndexOfSlash;
                }
            }
        };
    }

    private static class LogLine
    implements Serializable {
        private static final String LOG_ENTRY_PATTERN = "^(\\S+) (\\S+) (\\S+) \\[([\\w:/]+\\s[+\\-]\\d{4})\\] \"(\\S+) (\\S+) (\\S+)\" (\\d{3}) (\\d+)";
        private static final Pattern PATTERN = Pattern.compile("^(\\S+) (\\S+) (\\S+) \\[([\\w:/]+\\s[+\\-]\\d{4})\\] \"(\\S+) (\\S+) (\\S+)\" (\\d{3}) (\\d+)");
        private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
        private final String ipAddress;
        private final String clientIdentd;
        private final String userID;
        private final long timestamp;
        private final String method;
        private final String endpoint;
        private final String protocol;
        private final int responseCode;
        private final long contentSize;

        LogLine(String ipAddress, String clientIdentd, String userID, long timestamp, String method, String endpoint, String protocol, int responseCode, long contentSize) {
            this.ipAddress = ipAddress;
            this.clientIdentd = clientIdentd;
            this.userID = userID;
            this.timestamp = timestamp;
            this.method = method;
            this.endpoint = endpoint;
            this.protocol = protocol;
            this.responseCode = responseCode;
            this.contentSize = contentSize;
        }

        public static LogLine parse(String line) {
            Matcher m = PATTERN.matcher(line);
            if (!m.find()) {
                throw new IllegalArgumentException("Cannot parse log line: " + line);
            }
            long time = ZonedDateTime.parse(m.group(4), DATE_TIME_FORMATTER).toInstant().toEpochMilli();
            return new LogLine(m.group(1), m.group(2), m.group(3), time, m.group(5), m.group(6), m.group(7), Integer.parseInt(m.group(8)), Long.parseLong(m.group(9)));
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getClientIdentd() {
            return this.clientIdentd;
        }

        public String getUserID() {
            return this.userID;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMethod() {
            return this.method;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public long getContentSize() {
            return this.contentSize;
        }
    }
}

