/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.cache;

import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.optimizer.PlanCheckContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlanCacheChecker {
    private final NodeEngine nodeEngine;
    private final PlanCache planCache;
    private final List<TableResolver> tableResolvers;

    public PlanCacheChecker(NodeEngine nodeEngine, PlanCache planCache, List<TableResolver> tableResolvers) {
        this.nodeEngine = nodeEngine;
        this.planCache = planCache;
        this.tableResolvers = tableResolvers;
        this.tableResolvers.forEach(tableResolver -> tableResolver.registerListener(this::check));
    }

    public void check() {
        if (this.planCache.size() == 0) {
            return;
        }
        SqlCatalog catalog = new SqlCatalog(this.tableResolvers);
        HashSet<PlanObjectKey> objectKeys = new HashSet<PlanObjectKey>();
        for (Map<String, Table> tableMap : catalog.getSchemas().values()) {
            for (Table table : tableMap.values()) {
                PlanObjectKey objectKey = table.getObjectKey();
                if (objectKey == null || objectKey == PlanObjectKey.NON_CACHEABLE_OBJECT_KEY) continue;
                objectKeys.add(objectKey);
            }
        }
        Map<UUID, PartitionIdSet> partitions = QueryUtils.createPartitionMap(this.nodeEngine, null, false);
        this.planCache.check(new PlanCheckContext(objectKeys, partitions));
    }
}

