/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.security.Permission;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public final class UntrustedExpressionEvalContext
implements ExpressionEvalContext {
    private final List<Object> arguments;
    private final transient InternalSerializationService serializationService;
    private final transient NodeEngine nodeEngine;

    public UntrustedExpressionEvalContext(@Nonnull List<Object> arguments, @Nonnull InternalSerializationService serializationService, @Nonnull NodeEngine nodeEngine) {
        this.arguments = Objects.requireNonNull(arguments);
        this.serializationService = Objects.requireNonNull(serializationService);
        this.nodeEngine = Objects.requireNonNull(nodeEngine);
    }

    public static UntrustedExpressionEvalContext from(ExpressionEvalContext context) {
        return new UntrustedExpressionEvalContext(context.getArguments(), context.getSerializationService(), context.getNodeEngine());
    }

    @Override
    public Object getArgument(int index) {
        return this.arguments.get(index);
    }

    @Override
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public UntrustedExpressionEvalContext withSerializationService(@Nonnull InternalSerializationService newService) {
        if (this.serializationService == newService) {
            return this;
        }
        return new UntrustedExpressionEvalContext(this.arguments, newService, this.nodeEngine);
    }

    @Override
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void checkPermission(Permission permission) {
        if (this.isSecurityEnabled()) {
            throw new SecurityException("Unable to employ sensitive functions in untrusted invocations.");
        }
    }

    @Override
    @Nullable
    public Subject subject() {
        if (this.isSecurityEnabled()) {
            throw new SecurityException("Unable to employ sensitive functions in untrusted invocations.");
        }
        return null;
    }

    private boolean isSecurityEnabled() {
        return this.nodeEngine.getConfig().getSecurityConfig().isEnabled();
    }
}

