/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.triangulate.polygon;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.Orientation;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.quadedge.TrianglePredicate;
import com.hazelcast.shaded.org.locationtech.jts.triangulate.tri.Tri;
import java.util.List;

class TriDelaunayImprover {
    private static int MAX_ITERATION = 200;
    private List<Tri> triList;

    public static void improve(List<Tri> triList) {
        TriDelaunayImprover improver = new TriDelaunayImprover(triList);
        improver.improve();
    }

    private TriDelaunayImprover(List<Tri> triList) {
        this.triList = triList;
    }

    private void improve() {
        for (int i = 0; i < MAX_ITERATION; ++i) {
            int improveCount = this.improveScan(this.triList);
            if (improveCount != 0) continue;
            return;
        }
    }

    private int improveScan(List<Tri> triList) {
        int improveCount = 0;
        for (int i = 0; i < triList.size() - 1; ++i) {
            Tri tri = triList.get(i);
            for (int j = 0; j < 3; ++j) {
                if (!this.improveNonDelaunay(tri, j)) continue;
                ++improveCount;
            }
        }
        return improveCount;
    }

    private boolean improveNonDelaunay(Tri tri, int index) {
        Coordinate opp1;
        Coordinate opp0;
        Coordinate adj1;
        if (tri == null) {
            return false;
        }
        Tri tri1 = tri.getAdjacent(index);
        if (tri1 == null) {
            return false;
        }
        int index1 = tri1.getIndex(tri);
        Coordinate adj0 = tri.getCoordinate(index);
        if (!TriDelaunayImprover.isConvex(adj0, adj1 = tri.getCoordinate(Tri.next(index)), opp0 = tri.getCoordinate(Tri.oppVertex(index)), opp1 = tri1.getCoordinate(Tri.oppVertex(index1)))) {
            return false;
        }
        if (!TriDelaunayImprover.isDelaunay(adj0, adj1, opp0, opp1)) {
            tri.flip(index);
            return true;
        }
        return false;
    }

    private static boolean isConvex(Coordinate adj0, Coordinate adj1, Coordinate opp0, Coordinate opp1) {
        int dir1;
        int dir0 = Orientation.index(opp0, adj0, opp1);
        boolean isConvex = dir0 == (dir1 = Orientation.index(opp1, adj1, opp0));
        return isConvex;
    }

    private static boolean isDelaunay(Coordinate adj0, Coordinate adj1, Coordinate opp0, Coordinate opp1) {
        if (TriDelaunayImprover.isInCircle(adj0, adj1, opp0, opp1)) {
            return false;
        }
        return !TriDelaunayImprover.isInCircle(adj1, adj0, opp1, opp0);
    }

    private static boolean isInCircle(Coordinate a, Coordinate b, Coordinate c, Coordinate p) {
        return TrianglePredicate.isInCircleRobust(a, c, b, p);
    }
}

