/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.util;

import com.hazelcast.shaded.org.apache.calcite.util.NumberUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.nio.ByteOrder;
import java.text.NumberFormat;
import java.util.Locale;

public class ConversionUtil {
    public static final String NATIVE_UTF16_CHARSET_NAME = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? "UTF-16BE" : "UTF-16LE";
    public static final String TEST_UNICODE_STRING = "\u03b1\u03bd\u03b8\u03c1\u03c9\u03c0\u03bf\u03c2";
    public static final String TEST_UNICODE_SQL_ESCAPED_LITERAL = "\\03B1\\03BD\\03B8\\03C1\\03C9\\03C0\\03BF\\03C2";

    private ConversionUtil() {
    }

    public static String toStringFromByteArray(byte[] value, int radix) {
        assert (2 == radix || 16 == radix) : "Make sure that the algorithm below works for your radix";
        if (0 == value.length) {
            return "";
        }
        int trick = radix * radix;
        StringBuilder ret = new StringBuilder();
        for (byte b : value) {
            ret.append(Integer.toString(trick | 0xFF & b, radix).substring(1));
        }
        return ret.toString().toUpperCase(Locale.ROOT);
    }

    public static byte[] toByteArrayFromString(String value, int radix) {
        assert (16 == radix) : "Specified string to byte array conversion not supported yet";
        assert (value.length() % 2 == 0) : "Hex binary string must contain even number of characters";
        byte[] ret = new byte[value.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            int digit1 = Character.digit(value.charAt(i * 2), radix);
            int digit2 = Character.digit(value.charAt(i * 2 + 1), radix);
            assert (digit1 != -1 && digit2 != -1) : "String could not be converted to byte array";
            ret[i] = (byte)(digit1 * radix + digit2);
        }
        return ret;
    }

    public static String toStringFromApprox(double d, boolean isFloat) {
        NumberFormat nf = NumberUtil.getApproxFormatter(isFloat);
        return nf.format(d);
    }

    public static @Nullable Boolean toBoolean(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equalsIgnoreCase("TRUE")) {
            return Boolean.TRUE;
        }
        if (str.equalsIgnoreCase("FALSE")) {
            return Boolean.FALSE;
        }
        if (str.equalsIgnoreCase("UNKNOWN")) {
            return null;
        }
        throw Static.RESOURCE.invalidBoolean(str).ex();
    }
}

