/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.rules;

import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.ImmutableProjectJoinJoinRemoveRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectJoinJoinRemoveRule
extends RelRule<Config>
implements SubstitutionRule {
    protected ProjectJoinJoinRemoveRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectJoinJoinRemoveRule(Class<? extends Project> projectClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(projectClass, joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Join topJoin = (Join)call.rel(1);
        Join bottomJoin = (Join)call.rel(2);
        int leftBottomChildSize = bottomJoin.getLeft().getRowType().getFieldCount();
        for (RexNode expr2 : project.getProjects()) {
            if (!RelOptUtil.InputFinder.bits(expr2).asList().stream().anyMatch(i -> i >= leftBottomChildSize && i < bottomJoin.getRowType().getFieldCount())) continue;
            return;
        }
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(topJoin.getLeft(), topJoin.getRight(), topJoin.getCondition(), leftKeys, new ArrayList<Integer>(), new ArrayList<Boolean>());
        if (leftKeys.stream().anyMatch(s2 -> s2 >= leftBottomChildSize)) {
            return;
        }
        ArrayList<Integer> leftChildKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightChildKeys = new ArrayList<Integer>();
        RelOptUtil.splitJoinCondition(bottomJoin.getLeft(), bottomJoin.getRight(), bottomJoin.getCondition(), leftChildKeys, rightChildKeys, new ArrayList<Boolean>());
        if (!leftKeys.equals(leftChildKeys)) {
            return;
        }
        ImmutableBitSet.Builder columns = ImmutableBitSet.builder();
        rightChildKeys.forEach(columns::set);
        RelMetadataQuery mq = call.getMetadataQuery();
        if (!Boolean.TRUE.equals(mq.areColumnsUnique(bottomJoin.getRight(), columns.build()))) {
            return;
        }
        int offset = bottomJoin.getRight().getRowType().getFieldCount();
        RelBuilder relBuilder = call.builder();
        RexNode condition = RexUtil.shift(topJoin.getCondition(), leftBottomChildSize, -offset);
        RelNode join = relBuilder.push(bottomJoin.getLeft()).push(topJoin.getRight()).join(topJoin.getJoinType(), condition).build();
        List newExprs = project.getProjects().stream().map(expr -> RexUtil.shift(expr, leftBottomChildSize, -offset)).collect(Collectors.toList());
        relBuilder.push(join).project(newExprs);
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectJoinJoinRemoveRule.Config.of().withOperandFor(LogicalProject.class, LogicalJoin.class);

        @Override
        default public ProjectJoinJoinRemoveRule toRule() {
            return new ProjectJoinJoinRemoveRule(this);
        }

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(joinClass).predicate(j -> j.getJoinType() == JoinRelType.LEFT).inputs(b2 -> b2.operand(joinClass).predicate(j -> j.getJoinType() == JoinRelType.LEFT).anyInputs()))).as(Config.class);
        }
    }
}

