/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollations;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.mapping.Mappings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RelRoot {
    public final RelNode rel;
    public final RelDataType validatedRowType;
    public final SqlKind kind;
    public final ImmutableList<Pair<Integer, String>> fields;
    public final RelCollation collation;
    public final ImmutableList<RelHint> hints;

    public RelRoot(RelNode rel, RelDataType validatedRowType, SqlKind kind, List<Pair<Integer, String>> fields, RelCollation collation, List<RelHint> hints) {
        this.rel = rel;
        this.validatedRowType = validatedRowType;
        this.kind = kind;
        this.fields = ImmutableList.copyOf(fields);
        this.collation = Objects.requireNonNull(collation, "collation");
        this.hints = ImmutableList.copyOf(hints);
    }

    public static RelRoot of(RelNode rel, SqlKind kind) {
        return RelRoot.of(rel, rel.getRowType(), kind);
    }

    public static RelRoot of(RelNode rel, RelDataType rowType, SqlKind kind) {
        ImmutableIntList refs = ImmutableIntList.identity(rowType.getFieldCount());
        List<String> names = rowType.getFieldNames();
        return new RelRoot(rel, rowType, kind, Pair.zip(refs, names), RelCollations.EMPTY, new ArrayList<RelHint>());
    }

    public String toString() {
        return "Root {kind: " + (Object)((Object)this.kind) + ", rel: " + this.rel + ", rowType: " + this.validatedRowType + ", fields: " + this.fields + ", collation: " + this.collation + "}";
    }

    public RelRoot withRel(RelNode rel) {
        if (rel == this.rel) {
            return this;
        }
        return new RelRoot(rel, this.validatedRowType, this.kind, this.fields, this.collation, this.hints);
    }

    public RelRoot withKind(SqlKind kind) {
        if (kind == this.kind) {
            return this;
        }
        return new RelRoot(this.rel, this.validatedRowType, kind, this.fields, this.collation, this.hints);
    }

    public RelRoot withCollation(RelCollation collation) {
        return new RelRoot(this.rel, this.validatedRowType, this.kind, this.fields, collation, this.hints);
    }

    public RelRoot withHints(List<RelHint> hints) {
        return new RelRoot(this.rel, this.validatedRowType, this.kind, this.fields, this.collation, hints);
    }

    public RelNode project() {
        return this.project(false);
    }

    public RelNode project(boolean force) {
        if (this.isRefTrivial() && (SqlKind.DML.contains((Object)this.kind) || !force || this.rel instanceof LogicalProject)) {
            return this.rel;
        }
        ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>(this.fields.size());
        RexBuilder rexBuilder = this.rel.getCluster().getRexBuilder();
        for (Pair pair : this.fields) {
            projects.add(rexBuilder.makeInputRef(this.rel, (int)((Integer)pair.left)));
        }
        return LogicalProject.create(this.rel, this.hints, projects, Pair.right(this.fields), ImmutableSet.of());
    }

    public boolean isNameTrivial() {
        RelDataType inputRowType = this.rel.getRowType();
        return Pair.right(this.fields).equals(inputRowType.getFieldNames());
    }

    public boolean isRefTrivial() {
        if (SqlKind.DML.contains((Object)this.kind)) {
            return true;
        }
        RelDataType inputRowType = this.rel.getRowType();
        return Mappings.isIdentity(Pair.left(this.fields), inputRowType.getFieldCount());
    }

    public boolean isCollationTrivial() {
        List<RelCollation> collations = this.rel.getTraitSet().getTraits(RelCollationTraitDef.INSTANCE);
        return collations != null && collations.size() == 1 && collations.get(0).equals(this.collation);
    }
}

