/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.interpreter;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Compiler;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Context;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Node;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Row;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Scalar;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Sink;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.schema.Function;
import com.hazelcast.shaded.org.apache.calcite.schema.impl.TableFunctionImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;

public class TableFunctionScanNode
implements Node {
    private final Scalar scalar;
    private final Context context;
    private final Sink sink;
    private final Function1<?, Row> mapFn;

    private TableFunctionScanNode(Compiler compiler, TableFunctionScan rel) {
        RelDataType rowType = rel.getRowType();
        this.scalar = compiler.compile(ImmutableList.of(rel.getCall()), rowType);
        this.context = compiler.createContext();
        this.sink = compiler.sink(rel);
        this.mapFn = rowType.getFieldCount() == 1 && rel.getElementType() != Object[].class ? Row::of : Row::asCopy;
    }

    @Override
    public void run() throws InterruptedException {
        Object o = this.scalar.execute(this.context);
        if (o instanceof Enumerable) {
            Enumerator enumerator = ((Enumerable)o).select(this.mapFn).enumerator();
            while (enumerator.moveNext()) {
                this.sink.send((Row)enumerator.current());
            }
        }
    }

    static TableFunctionScanNode create(Compiler compiler, TableFunctionScan rel) {
        Function function;
        SqlOperator operator;
        RexNode call = rel.getCall();
        if (call instanceof RexCall && (operator = ((RexCall)call).getOperator()) instanceof SqlUserDefinedTableFunction && (function = ((SqlUserDefinedTableFunction)operator).function) instanceof TableFunctionImpl) {
            return new TableFunctionScanNode(compiler, rel);
        }
        throw new AssertionError((Object)("cannot convert table function scan " + rel.getCall() + " to enumerable"));
    }
}

