/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRelFactories;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableSort;
import com.hazelcast.shaded.org.apache.calcite.plan.Contexts;
import com.hazelcast.shaded.org.apache.calcite.plan.Convention;
import com.hazelcast.shaded.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTrait;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitDef;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollations;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public enum EnumerableConvention implements Convention
{
    INSTANCE;

    public static final double COST_MULTIPLIER = 1.0;

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public Class getInterface() {
        return EnumerableRel.class;
    }

    @Override
    public String getName() {
        return "ENUMERABLE";
    }

    @Override
    public @Nullable RelNode enforce(RelNode input, RelTraitSet required) {
        Object collation;
        RelNode rel = input;
        if (input.getConvention() != INSTANCE) {
            rel = ConventionTraitDef.INSTANCE.convert(input.getCluster().getPlanner(), input, INSTANCE, true);
            Objects.requireNonNull(rel, () -> "Unable to convert input to " + INSTANCE + ", input = " + input);
        }
        if ((collation = required.getCollation()) != null && collation != RelCollations.EMPTY) {
            rel = EnumerableSort.create(rel, collation, null, null);
        }
        return rel;
    }

    @Override
    public RelTraitDef getTraitDef() {
        return ConventionTraitDef.INSTANCE;
    }

    @Override
    public boolean satisfies(RelTrait trait) {
        return this == trait;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean canConvertConvention(Convention toConvention) {
        return false;
    }

    @Override
    public boolean useAbstractConvertersForConversion(RelTraitSet fromTraits, RelTraitSet toTraits) {
        return true;
    }

    @Override
    public RelFactories.Struct getRelFactories() {
        return RelFactories.Struct.fromContext(Contexts.of(EnumerableRelFactories.ENUMERABLE_TABLE_SCAN_FACTORY, EnumerableRelFactories.ENUMERABLE_PROJECT_FACTORY, EnumerableRelFactories.ENUMERABLE_FILTER_FACTORY, EnumerableRelFactories.ENUMERABLE_SORT_FACTORY));
    }
}

