/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.typeinference;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class ReplaceUnknownOperandTypeInference
implements SqlOperandTypeInference {
    private final SqlTypeName[] typeNames;
    private final SqlTypeName defaultTypeName;

    public ReplaceUnknownOperandTypeInference(SqlTypeName[] typeNames) {
        this(typeNames, null);
    }

    public ReplaceUnknownOperandTypeInference(SqlTypeName defaultTypeName) {
        this(null, defaultTypeName);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ReplaceUnknownOperandTypeInference(SqlTypeName[] typeNames, SqlTypeName defaultTypeName) {
        this.typeNames = typeNames;
        this.defaultTypeName = defaultTypeName;
    }

    @Override
    public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypes) {
        for (int i = 0; i < operandTypes.length; ++i) {
            RelDataType operandType = callBinding.getOperandType(i);
            if (HazelcastTypeUtils.isNullOrUnknown(operandType.getSqlTypeName())) {
                RelDataType resolvedOperandType = this.resolveOperandType(i, callBinding.getTypeFactory());
                if (operandType.isNullable()) {
                    resolvedOperandType = HazelcastTypeUtils.createNullableType(callBinding.getTypeFactory(), resolvedOperandType);
                }
                operandType = resolvedOperandType;
            }
            operandTypes[i] = operandType;
        }
    }

    private RelDataType resolveOperandType(int index, RelDataTypeFactory typeFactory) {
        SqlTypeName typeName = null;
        if (this.typeNames != null && index < this.typeNames.length) {
            typeName = this.typeNames[index];
        }
        if (typeName == null) {
            typeName = this.defaultTypeName;
        }
        assert (typeName != null);
        return typeFactory.createSqlType(typeName);
    }
}

