/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.SqlDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableNullableList;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlTypeColumn
extends SqlCall {
    private static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("COLUMN DECLARATION", SqlKind.COLUMN_DECL);
    private final SqlIdentifier name;
    private final SqlDataType type;

    public SqlTypeColumn(SqlIdentifier name, SqlDataType type, SqlParserPos pos) {
        super(pos);
        this.name = Objects.requireNonNull(name, "Column name should not be null");
        this.type = Objects.requireNonNull(type, "Column type should not be null");
    }

    public String name() {
        return this.name.getSimple();
    }

    public QueryDataType type() {
        return this.type != null ? this.type.type() : null;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.name, this.type);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.type != null) {
            this.type.unparse(writer, leftPrec, rightPrec);
        }
    }
}

