/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.union;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTWriter;
import com.hazelcast.shaded.org.locationtech.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;
import test.jts.perf.operation.union.UnionPerfTester;

public class PolygonUnionPerfTest {
    static final int MAX_ITER = 1;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    static WKTWriter wktWriter = new WKTWriter();
    GeometryFactory factory = new GeometryFactory();
    boolean testFailed = false;

    public static void main(String[] args) {
        PolygonUnionPerfTest test = new PolygonUnionPerfTest();
        test.testRampItems();
    }

    public void testRampItems() {
        int nPts = 1000;
        this.test(5, nPts, 10.0);
        this.test(5, nPts, 10.0);
        this.test(25, nPts, 10.0);
        this.test(50, nPts, 10.0);
        this.test(100, nPts, 10.0);
        this.test(200, nPts, 10.0);
        this.test(400, nPts, 10.0);
        this.test(500, nPts, 10.0);
        this.test(1000, nPts, 10.0);
        this.test(2000, nPts, 10.0);
        this.test(4000, nPts, 10.0);
    }

    public void test() {
        this.test(1000, 100, 10.0);
    }

    public void test(int nItems, int nPts, double size) {
        System.out.println("---------------------------------------------------------");
        System.out.println("# pts/item: " + nPts);
        List polys = this.createPolys(nItems, size, nPts);
        UnionPerfTester tester = new UnionPerfTester(polys);
        tester.runAll();
    }

    List createPolys(int nItems, double size, int nPts) {
        double overlapPct = 0.2;
        int nCells = (int)Math.sqrt(nItems);
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        double width = (double)nCells * (1.0 - overlapPct) * size;
        double height = (double)(nCells * 2) * size;
        double xInc = width / (double)nCells;
        double yInc = height / (double)nCells;
        for (int i = 0; i < nCells; ++i) {
            for (int j = 0; j < nCells; ++j) {
                Coordinate base = new Coordinate((double)i * xInc, (double)j * yInc);
                Geometry poly = this.createPoly(base, size, nPts);
                geoms.add(poly);
            }
        }
        return geoms;
    }

    Geometry createPoly(Coordinate base, double size, int nPts) {
        GeometricShapeFactory gsf = new GeometricShapeFactory(this.factory);
        gsf.setCentre(base);
        gsf.setSize(size);
        gsf.setNumPoints(nPts);
        Polygon poly = gsf.createCircle();
        return poly;
    }
}

