/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.geom.TopologyException;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.AffineTransformation;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.PolygonExtracter;
import com.hazelcast.shaded.org.locationtech.jts.noding.Noder;
import com.hazelcast.shaded.org.locationtech.jts.noding.ValidatingNoder;
import com.hazelcast.shaded.org.locationtech.jts.noding.snap.SnappingNoder;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlay.OverlayOp;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNG;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import java.util.Collection;
import java.util.List;
import test.jts.perf.operation.overlayng.RandomPolygonBuilder;

public class RandomPolygonOverlayFuzzer {
    static final boolean IS_VERBOSE = false;
    static final boolean IS_SAME_VORONOI = false;
    static final int N_PTS = 100;
    static final int N_TESTS = 1000;
    static double SCALE = 1.0E8;
    static double[] SCALES = new double[]{1.0, 100.0, 10000.0, 1000000.0, 1.0E8, 1.0E12};
    private int testIndex = 0;
    private int errCount = 0;
    private String testDesc = "";

    private void overlay(Geometry poly1, Geometry poly2) {
        this.overlayNGRobust(poly1, poly2);
    }

    static void log(String msg) {
    }

    private boolean useSameBase() {
        return 0 == this.testIndex % 2;
    }

    public static void main(String[] args) {
        new RandomPolygonOverlayFuzzer().run();
    }

    private void run() {
        System.out.printf("Running %d tests\n", 1000);
        for (int i = 1; i <= 1000; ++i) {
            this.testIndex = i;
            this.overlayPolys();
            if ((i + 1) % 100 != 0) continue;
            System.out.print(".");
            if ((i + 1) % 10000 != 0) continue;
            System.out.println();
        }
        System.out.println("\n============================");
        System.out.printf("Tests: %d  Errors: %d\n", 1000, this.errCount);
    }

    private void overlayPolys() {
        boolean isUseSameBase = this.useSameBase();
        Geometry[] poly = RandomPolygonOverlayFuzzer.createPolygons(100, isUseSameBase);
        this.process(poly[0], poly[1]);
    }

    private void process(Geometry poly1, Geometry poly2) {
        try {
            this.overlay(poly1, poly2);
        }
        catch (TopologyException ex) {
            ++this.errCount;
            System.out.println(this.stats());
            System.out.printf("ERROR - %s\n", ex.getMessage());
            System.out.println(poly1);
            System.out.println(poly2);
        }
    }

    private String stats() {
        return String.format("\nTest %d: %s   (# errs: %d = %d%%)\n", this.testIndex, this.testDesc, this.errCount, 100 * this.errCount / this.testIndex);
    }

    private void overlayNG(Geometry poly1, Geometry poly2) {
        RandomPolygonOverlayFuzzer.log("Test: " + this.testIndex + "  --------------------");
        for (double scale : SCALES) {
            this.overlayNG(poly1, poly2, scale);
        }
    }

    private void overlayNG(Geometry poly1, Geometry poly2, double scale) {
        this.testDesc = String.format("OverlayNG  scale: %f", scale);
        RandomPolygonOverlayFuzzer.log(this.testDesc);
        PrecisionModel pm = this.precModel(scale);
        Geometry inter = OverlayNG.overlay((Geometry)poly1, (Geometry)poly2, (int)1, (PrecisionModel)pm);
        Geometry symDiff = OverlayNG.overlay((Geometry)poly1, (Geometry)poly2, (int)4, (PrecisionModel)pm);
        Geometry union = OverlayNG.overlay((Geometry)RandomPolygonOverlayFuzzer.onlyPolys(inter), (Geometry)RandomPolygonOverlayFuzzer.onlyPolys(symDiff), (int)2, (PrecisionModel)pm);
    }

    private static Geometry onlyPolys(Geometry geom) {
        List polyList = PolygonExtracter.getPolygons((Geometry)geom);
        return geom.getFactory().createMultiPolygon(GeometryFactory.toPolygonArray((Collection)polyList));
    }

    private PrecisionModel precModel(double scale) {
        if (scale <= 0.0) {
            return new PrecisionModel();
        }
        return new PrecisionModel(scale);
    }

    private void overlayNGFloat(Geometry poly1, Geometry poly2) {
        OverlayNG.overlay((Geometry)poly1, (Geometry)poly2, (int)1);
    }

    private void overlayNGRobust(Geometry poly1, Geometry poly2) {
        OverlayNGRobust.overlay((Geometry)poly1, (Geometry)poly2, (int)1);
        poly1.intersection(poly2);
    }

    private void overlayOrig(Geometry poly1, Geometry poly2) {
        poly1.intersection(poly2);
    }

    private void overlayOrigNoSnap(Geometry a, Geometry b) {
        OverlayOp.overlayOp((Geometry)a, (Geometry)b, (int)1);
    }

    private void overlayNGSnapping(Geometry a, Geometry b) {
        RandomPolygonOverlayFuzzer.unionSnap(a, b, 1.0E-5);
    }

    public static Geometry unionSnap(Geometry a, Geometry b, double tolerance) {
        Noder noder = RandomPolygonOverlayFuzzer.getNoder(tolerance);
        return OverlayNG.overlay((Geometry)a, (Geometry)b, (int)2, null, (Noder)noder);
    }

    private static Noder getNoder(double tolerance) {
        SnappingNoder snapNoder = new SnappingNoder(tolerance);
        return new ValidatingNoder((Noder)snapNoder);
    }

    private static Geometry[] createPolygons(int npts, boolean isUseSameBase) {
        RandomPolygonBuilder builder = new RandomPolygonBuilder(npts);
        Geometry poly1 = builder.createPolygon();
        RandomPolygonBuilder builder2 = builder;
        if (!isUseSameBase) {
            builder2 = new RandomPolygonBuilder(npts);
        }
        Geometry poly2 = builder2.createPolygon();
        poly2 = RandomPolygonOverlayFuzzer.perturbByRotation(poly2);
        return new Geometry[]{poly1, poly2};
    }

    private static Geometry perturbByRotation(Geometry geom) {
        AffineTransformation rot = AffineTransformation.rotationInstance((double)(Math.PI * 2));
        Geometry geomRot = geom.copy();
        geomRot.apply((CoordinateSequenceFilter)rot);
        return geomRot;
    }

    private void checkValid(Geometry poly) {
        if (poly.isValid()) {
            return;
        }
        System.out.println("INVALID!");
        System.out.println(poly);
    }
}

