/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.distance;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygon;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.SineStarFactory;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;

public class TestPerfDistanceGeomSet {
    static final int MAX_ITER = 1;
    static final int NUM_GEOM = 100;
    static final double GEOM_SIZE = 1.0;
    static final double MAX_X = 100.0;
    boolean testFailed = false;
    boolean verbose = false;
    double size = 100.0;
    double separationDist = this.size * 2.0;

    public static void main(String[] args) {
        TestPerfDistanceGeomSet test = new TestPerfDistanceGeomSet();
        test.test();
    }

    public void test() {
        this.test(10);
        this.test(3);
        this.test(4);
        this.test(5);
        this.test(10);
        this.test(20);
        this.test(30);
        this.test(40);
        this.test(50);
        this.test(60);
        this.test(100);
        this.test(200);
        this.test(500);
        this.test(1000);
        this.test(5000);
        this.test(10000);
        this.test(50000);
        this.test(100000);
    }

    public void test2() {
        this.verbose = false;
        for (int i = 800; i <= 2000; i += 100) {
            this.test(i);
        }
    }

    public void test(int num) {
        Geometry[] geom = this.createRandomCircles(100, 5, num);
        if (this.verbose) {
            System.out.println("Running with " + num + " points");
        }
        if (!this.verbose) {
            System.out.print(num + ", ");
        }
        this.test(geom);
    }

    public void test(Geometry[] geom) {
        Stopwatch sw = new Stopwatch();
        double dist = 0.0;
        for (int i = 0; i < 1; ++i) {
            this.testAll(geom);
        }
        if (!this.verbose) {
            System.out.println(sw.getTimeString());
        }
        if (this.verbose) {
            System.out.println("Finished in " + sw.getTimeString());
            System.out.println("       (Distance = " + dist + ")");
        }
    }

    void testAll(Geometry[] geom) {
        for (int i = 0; i < geom.length; ++i) {
            for (int j = 0; j < geom.length; ++j) {
                double d = geom[i].distance(geom[j]);
            }
        }
    }

    Geometry[] createRandomCircles(int nPts) {
        Geometry[] geoms = new Geometry[100];
        for (int i = 0; i < 100; ++i) {
            geoms[i] = this.createCircleRandomLocation(nPts);
        }
        return geoms;
    }

    Geometry[] createRandomCircles(int numGeom, int nPtsMin, int nPtsMax) {
        int nPtsRange = nPtsMax - nPtsMin + 1;
        Geometry[] geoms = new Geometry[numGeom];
        for (int i = 0; i < numGeom; ++i) {
            int nPts = (int)((double)nPtsRange * Math.random()) + nPtsMin;
            geoms[i] = this.createCircleRandomLocation(nPts);
        }
        return geoms;
    }

    Geometry createCircleRandomLocation(int nPts) {
        SineStarFactory gsf = new SineStarFactory();
        gsf.setCentre(this.randomLocation());
        gsf.setSize(1.0);
        gsf.setNumPoints(nPts);
        Polygon g = gsf.createCircle();
        return g;
    }

    Coordinate randomLocation() {
        double x = Math.random() * 100.0;
        double y = Math.random() * 100.0;
        return new Coordinate(x, y);
    }
}

