/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.LineString;
import com.hazelcast.shaded.org.locationtech.jts.geom.Polygonal;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.BufferParameters;
import com.hazelcast.shaded.org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

public class OffsetCurveCorrectnessTest {
    private PrecisionModel precisionModel = new PrecisionModel();
    private GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader rdr = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        try {
            new OffsetCurveCorrectnessTest().run7();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void run7() throws Exception {
        String wkt = "MULTILINESTRING ((1335558.59524 631743.01449, 1335572.28215 631775.89056, 1335573.2578018496 631782.1915185435),  (1335573.2578018496 631782.1915185435, 1335576.62035 631803.90754),  (1335558.59524 631743.01449, 1335573.2578018496 631782.1915185435),  (1335573.2578018496 631782.1915185435, 1335580.70187 631802.08139))";
        Geometry g = this.rdr.read(wkt);
        Geometry curve = OffsetCurveCorrectnessTest.bufferOffsetCurve(g, 15.0);
        System.out.println(curve);
    }

    public static Geometry bufferOffsetCurve(Geometry g, double distance) {
        OffsetCurveBuilder ocb = new OffsetCurveBuilder(g.getFactory().getPrecisionModel(), new BufferParameters());
        Coordinate[] pts = g.getCoordinates();
        Coordinate[] curvePts = null;
        curvePts = g instanceof Polygonal ? ocb.getRingCurve(pts, 1, distance) : ocb.getLineCurve(pts, distance);
        LineString curve = g.getFactory().createLineString(curvePts);
        return curve;
    }
}

