/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf.operation.buffer;

import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFactory;
import com.hazelcast.shaded.org.locationtech.jts.geom.PrecisionModel;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTFileReader;
import com.hazelcast.shaded.org.locationtech.jts.io.WKTReader;
import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.util.List;
import test.jts.TestFiles;

public class FileBufferPerfTest {
    static final int MAX_ITER = 1;
    static PrecisionModel pm = new PrecisionModel();
    static GeometryFactory fact = new GeometryFactory(pm, 0);
    static WKTReader wktRdr = new WKTReader(fact);
    GeometryFactory factory = new GeometryFactory();
    boolean testFailed = false;

    public static void main(String[] args) {
        FileBufferPerfTest test = new FileBufferPerfTest();
        try {
            test.test();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void test() throws Exception {
        this.test(TestFiles.getResourceFilePath("africa.wkt"));
    }

    public void test(String filename) throws Exception {
        WKTFileReader fileRdr = new WKTFileReader(filename, wktRdr);
        List polys = fileRdr.read();
        this.runAll(polys, 0.01);
        this.runAll(polys, 0.1);
        this.runAll(polys, 1.0);
        this.runAll(polys, 10.0);
        this.runAll(polys, 100.0);
        this.runAll(polys, 1000.0);
    }

    void runAll(List polys, double distance) {
        System.out.println("Geom count = " + polys.size() + "   distance = " + distance);
        Stopwatch sw = new Stopwatch();
        for (Geometry g : polys) {
            g.buffer(distance);
            System.out.print(".");
        }
        System.out.println();
        System.out.println("   Time = " + sw.getTimeString());
    }
}

