/*
 * Decompiled with CFR 0.152.
 */
package test.jts.perf;

import com.hazelcast.shaded.org.locationtech.jts.util.Stopwatch;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import test.jts.perf.PerformanceTestCase;

public class PerformanceTestRunner {
    private static final String RUN_PREFIX = "run";
    private static final String INIT_METHOD = "init";

    public static void run(Class clz) {
        PerformanceTestRunner runner = new PerformanceTestRunner();
        runner.runInternal(clz);
    }

    private PerformanceTestRunner() {
    }

    private void runInternal(Class clz) {
        try {
            Constructor ctor = clz.getConstructor(String.class);
            PerformanceTestCase test = (PerformanceTestCase)ctor.newInstance("Name");
            int[] runSize = test.getRunSize();
            int runIter = test.getRunIterations();
            Method[] runMethod = PerformanceTestRunner.findMethods(clz, RUN_PREFIX);
            test.setUp();
            for (int runNum = 0; runNum < runSize.length; ++runNum) {
                int size = runSize[runNum];
                test.startRun(size);
                for (int i = 0; i < runMethod.length; ++i) {
                    Stopwatch sw = new Stopwatch();
                    for (int iter = 0; iter < runIter; ++iter) {
                        runMethod[i].invoke((Object)test, new Object[0]);
                    }
                    long time = sw.getTime();
                    System.out.println(runMethod[i].getName() + " : " + sw.getTimeString());
                    test.setTime(runNum, time);
                }
                test.endRun();
            }
            test.tearDown();
        }
        catch (InvocationTargetException e) {
            e.getTargetException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Method[] findMethods(Class clz, String methodPrefix) {
        ArrayList<Method> runMeths = new ArrayList<Method>();
        Method[] meth = clz.getDeclaredMethods();
        for (int i = 0; i < meth.length; ++i) {
            if (!meth[i].getName().startsWith(RUN_PREFIX)) continue;
            runMeths.add(meth[i]);
        }
        return runMeths.toArray(new Method[0]);
    }
}

